#
# BETATRON high level library for platform and action arcade games.
# Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
#
# DTROWTIL.S: This file is part of the BETATRON library and can be used
#             and/or distributed only under the terms of the GNU Library
#             General Public License. See doc/readme.1st for details.
#



.extern _pl_a000h
.globl	_drawtrowtile

#/*
#----------------------------------------------------------------------------
# extern "C" void drawttile(char *tile,unsigned char tilex,
#			    unsigned char tiley,
#			    unsigned short pageofs);
#
# drawttile =  draw thru tile
# 坜  椞 ⤘ tile,  妬  ᩜ 夘 1616
# tile:    填  ⤘ array[256] of byte
# tilex:    ⤞ ( 16ᛜ pixel) ᤠ  tile
# tiley:    ⤞ ....
# pageofs:  矬 ᡨ   video memory
#	    ᤠ  modex   㡦  352 pixel
#	   , 88 礩  video ram
#	    tile ਜ嫘   , 槦 ᨮ
#	   飘 0 夘 .
#----------------------------------------------------------------------------
#*/

.equ savedebp6	,    0
.equ retadr6	,    4
.equ tile6	,    8
.equ tilex6	,    12
.equ tiley6	 ,   16
.equ pageofs6	 ,   20
.equ rowno6	 ,   24


_drawtrowtile:

	pushl	%ebp
	movl	%esp,%ebp

	pusha
	pushw %es
	mov _pl_a000h,%ax
	mov %ax,%es

	xorl	%ecx,%ecx
	movl	tile6(%ebp),%esi     # //tile

	movb	rowno6(%ebp),%cl      # rowno
	shlb	$4,%cl	#cl=rowno*16  ,4 byte gia kathe grammi ana bitplane

	addl	%ecx,%esi	# apomakrinsi logo grammis
	movw	%cx,%ax
	movb	$22,%cl
	mulb	%cl	# ax = rowno*(88*4) ,apomakrinsi gia ton di
	movw	%ax,%cx # cx = ax

	xorl	%edi,%edi

	movw	$352,%ax
	movb	tiley6(%ebp),%bl      # //tiley
	xorb	%bh,%bh
	mulw	%bx
	movb	tilex6(%ebp),%bl      # //tilex
	addw	%bx,%ax
	shlw	$2,%ax	#  //ax = (tiley*16*22*16 + tilex*16) / 4

	movw	pageofs6(%ebp),%di    # //pageofs

	addw	%ax,%di # // o di  矬   tile  video ram
	addw	%cx,%di

	movw	$0x03c4,%dx	# //sequencer controller  bitplane masking


	xorb	%cl,%cl # //proto bitplane

nextplane:

	movw	$4,%bx	# // bx: , 4 grammes /row

	movb	$0x02,%al	# // map mask register
	movb	$0x01,%ah	#
	shlb	%cl,%ah # // epelekse to katallilo bitplane
	outw	%ax,%dx

nextline:

	lodsb
	testb	%al,%al
	jz	dontplotit0
	movb	%al,%es:(%edi)
dontplotit0:
	incw	%di
	lodsb
	testb	%al,%al
	jz	dontplotit1
	movb	%al,%es:(%edi)
dontplotit1:
	incw	%di
	lodsb
	testb	%al,%al
	jz	dontplotit2
	movb	%al,%es:(%edi)
dontplotit2:
	incw	%di
	lodsb
	testb	%al,%al
	jz	dontplotit3
	movb	%al,%es:(%edi)
dontplotit3:
	incw	%di

	addw	$84,%di #//  di 室  棜 

	decw	%bx
	jnz	nextline

	subw	$4*88,%di	# // o di na ksanadeiksei sthn arxh toy tile
	addl	$48,%esi

	incb	%cl
	cmpb	$4,%cl	# // ftasame sto 4o bitplane
	jne	nextplane      # // an oxi proxora sto epomeno

	popw	%es
	popa
	popl	%ebp

	ret

.END
