#include "buffer.h"
#include "colour.h"
#include "desktop.h"
#include "error.h"
#include "misc.h"

/*

	buffer.c

		Draw buffer.

		C-Desktop
		Copyright (C)1998, Brett Porter.

*/

void	Buffer_Print( T_Buffer *aBuffer, int aX1, int aY1, int aX2, int aY2, const char *aStr, int aColour )
{
	int	x, y, lAttr, i;
	byte	*lBuffer = aBuffer->fBuffer;

	if ( aX1 > aX2 || aY1 > aY2 )
	{
		return;
	}

	lAttr = Colour_GetAttribute( aColour );

	lBuffer += ( aBuffer->fWidth*aY1+aX1 )*2;

	x = aX1;
	y = aY1;

	/// more effecient way to handle -ve's

	for ( i = strlen( aStr ); i--; aStr++ )
	{
		if ( *aStr == '\n' )
		{
			y++;
			lBuffer += ( aBuffer->fWidth-x+aX1 )*2;
			x = aX1;
		}
		else
		{
			if ( x >= 0 && y >= 0 && x < aBuffer->fWidth && y < aBuffer->fHeight )
			{
				*lBuffer++ = *aStr;
				*lBuffer++ = lAttr;
			}
			else
			{
				lBuffer += 2;
			}
			x++;
			if ( x > aX2 )
			{
				lBuffer += ( aBuffer->fWidth-x+aX1 )*2;
				x = aX1;
				y++;
			}
		}
		if ( y > aY2 )
		{
			break;
		}
	}
}

T_Buffer	*Buffer_Create( int aW, int aH )
{
	T_Buffer	*lBuffer;

	P_InitVar( lBuffer, T_Buffer );

	lBuffer->fWidth = aW;
	lBuffer->fHeight = aH;

	lBuffer->fBuffer = ( byte* )malloc( aW*aH*2 );

	return lBuffer;
}

void	Buffer_Kill( T_Buffer *aBuffer )
{
	free( aBuffer->fBuffer );
	free( aBuffer );
}



