/********************************************************


                         CEKANI

           .ANI File Loader Library to DJGPP.

      Copyright (c) 2000 by Cristian EmmericK (CEK)

              E-mail: cek@mailbr.com.br

                 ICQ(UIN): 52438873


*********************************************************

                        FILE INFO:

  EX02.C

  Example 02, demostrate how to get information about the
cursor .ANI file.


********************************************************/



#include "allegro.h"

#include "cekani.h"

void main(int argc, char *argv[])
{
  /* declare a cursor type */
  CURSOR *cursor;

  int a;

  /* init allegro */
  allegro_init();

  set_color_depth(8);

  if(!argv[1])
  {
    printf("CEKANI Example 02.\nUsage: ex02 <.ani file>\n");
    exit(0);
  }

  /* load .ANI file */
  cursor=load_ani(argv[1]);
  if(!cursor) {allegro_exit(); printf("Error Loading %s file!",argv[1]); exit(0);}

  printf("CEKANI Example 02.\n\nCursor info:");
  printf("\n        Name: %s",cursor_getname(cursor));
  printf("\n      Author: %s",cursor_getauthor(cursor));
  printf("\n        Size: %ld",cursor_getsize(cursor));
  printf("\n       Width: %d",cursor_width(cursor));
  printf("\n      Height: %d",cursor_height(cursor));
  printf("\n      Frames: %d",cursor_frames(cursor));
  printf("\n       Steps: %d",cursor_steps(cursor));
  printf("\n Color Depth: %d",cursor_getcolordepth(cursor));

  printf("\nRate:\n");
  for(a=0;a<cursor_steps(cursor);a++) printf("%02d: %3ld ",a,cursor_rate(cursor,a));
  printf("\nSequence:\n");
  for(a=0;a<cursor_steps(cursor);a++) printf("%02d: %3ld ",a,cursor_seq(cursor,a));


  /* uinit allegro */
  allegro_exit();
}
