/*
 * Copyright (C) 1996-1998 Ilya Ryzhenkov (orangy@inetlab.com)
 */
//#include <string.h>
#include "dlmimage.h"
#include "dlm_sym.h"

/*
 * This function exports some functions already used in
 * DLM engine for DLMs to be able to use them without loading
 * anything else
 */

#define EXP(name) extern void name(void);
#define EXPD(name) extern int name;
#define EXPC(name) extern int name;

#ifndef DETECT_USED
#include "dlmexp.hh"
#endif

#undef EXP
#undef EXPD
#undef EXPC

#define EXP(name)  if (!_sym_add_export("_"#name, name,(TDlm*)-1)) return 0;
#define EXPD(name) if (!_sym_add_export("_"#name,&name,(TDlm*)-1)) return 0;
#define EXPC(name) if (!_sym_add_export("_"#name,&name,(TDlm*)-1)) return 0;

int _dlm_export_standard(void)
{
 #ifndef DETECT_USED 
 #include "dlmexp.hh"
 #endif

 if (!_sym_add_export("_isLoadedDLM",_dlm_isloaded,(TDlm*)-1)) return 0;
 if (!_sym_add_export("_UnloadDLM",_dlm_unload,(TDlm*)-1)) return 0;
 if (!_sym_add_export("_LoadDLM",_dlm_load,(TDlm*)-1)) return 0;
 if (!_sym_add_export("_SetDLMSearchPath",_dlm_set_search_path,(TDlm*)-1)) return 0;
 if (!_sym_add_export("_dlmerrno",&dlmerrno,(TDlm*)-1)) return 0;
 if (!_sym_add_export("_dlmflags",&dlmflags,(TDlm*)-1)) return 0;
 if (!_sym_add_export("_LookupDLMSymbol",_dlm_lookup,(TDlm*)-1)) return 0;
 if (!_sym_add_export("_SizeofDLMSymbol",_dlm_extra_size,(TDlm*)-1)) return 0;
 if (!_sym_add_export("_ExportDLMSymbol",_dlm_export_user,(TDlm*)-1)) return 0;
 if (!_sym_add_export("_RemoveDLMSymbol",_dlm_remove_user,(TDlm*)-1)) return 0;
 if (!_sym_add_export("___nw__FUlPcP16_SYSDLM_newdummy",_dlm_new_named,(TDlm*)-1)) return 0;

 return 1;
}

#undef EXP
#undef EXPD

