/*
 * Copyright (C) 1996-1998 Ilya Ryzhenkov (orangy@inetlab.com)
 * This file maintains startup sequence.
 */
#include "dlmimage.h"
#include "helpdefs.h"
#include "dlm_sym.h"
#include "hash.h"

#define USEARG 0

void _dlm_init_signal_handlers(void);
void _dlm_reset_signal_handlers(void);
int _dlm_export_standard(void);
void _dlm_npxsetup();
extern unsigned long cache_hits;

static
void _dlm_atexit()
{
 _dlm_reset_signal_handlers();
 _dlm_unload_all();
}

int (*dlm_main)(int argc,char **argv);
int main(int argc,char **argv)
{
 void *symaddr;
 int retcode=-1;
 _dlm_init_signal_handlers();
 atexit(_dlm_atexit);
 if (!_sym_init_tables() || !_dlm_export_standard())
  {
   puts("FATAL: DLMStub was failed to initialize internal tables");
   return -1;
  }
 _dlm_set_search_path(getenv("DLMPATH"));
 _dlm_npxsetup();
 if (!_dlm_load(argv[USEARG]))
 {
  puts("FATAL: DLMStub was failed to load DLM from executable");
  return -1;
 }
 symaddr=_sym_find_export("_main",0);
 if (symaddr)
  {
   dlm_main=(int (*)(int,char **))symaddr;
   retcode=dlm_main(argc-USEARG,argv+USEARG);
  } else
  {
   puts("FATAL: DLMStub was failed to find symbol '_main'");
   retcode=-1;
  }
  _dlm_unload(argv[USEARG]);
  /* printf("Total cache improvement : %ld\n",cache_hits); */
  return retcode;
}

