#ifndef MNF_JPTUI_MESSAGE_BOX_HPP
#define MNF_JPTUI_MESSAGE_BOX_HPP

#include "ButtonsBox.hpp"
#include "tlabel.h"
#include "tchkbox.h"

namespace jptui {

class MessageBox : public ButtonsBox
{
public:
	enum Icon 
	{ 
		NO_ICON, STOP_ICON, QUESTION_ICON,  EXCLAMATION_ICON, INFORMATION_ICON 
	};
	void	init(const char* title, int windowStyle, const char* text, 
				 Icon icon, const ButtonDescr* ds, 
				 int defaultButton, int cancelButton, 
			     const char* checkBoxTitle = 0, bool checkBoxValue = false);
	bool	checkBoxValue();
private:
	std::auto_ptr<TLabel>		iconLabel_;
	std::auto_ptr<TLabel>		textLabel_;
	std::auto_ptr<TCheckBox>	checkBox_;
	const char*	getIconText(Icon icon);
};

} // namespace jptui

#endif//MNF_JPTUI_MESSAGE_BOX_HPP
