#include <stdio.h>
#include <iostream.h>
#include <malloc.h>
#include "dlx.h"
class CDLXImports {
        protected:
                char** names;
                long* numlocs;
                long** relocs;
                long numimports;
        public:
                CDLXImports(FILE* infile, long nums);
                ~CDLXImports();
                void Replace(char* data, char* name, char* placement);
                void CheckEmpty();
};
class CDLXSymbolList {
        protected:
                char*** tosymbols;
                char** names;
                long numdlx;
        public:
                CDLXSymbolList();
                void AddExports(char *name, char** tosymbol);
                void Resolve(CDLXImports& ims, char* data);
                void RemoveExports(char*name);
};
static CDLXSymbolList GlobalSymbols;
class CDLX {
        protected:
                char* data;
                void (*LibMain)(int);
                char* name;
                long instance;
                long libloadpos;
        public:
                CDLX(char* iname, FILE* infile);
                ~CDLX();
                int operator==(char*);
                int operator!();
                int operator++();
                int operator--();
};
static FILE* _DefaultOpen(char* name){return(fopen(name,"rb"));}
static void _DefaultError(char *i){cout << "DLX Error!" << endl << i << endl;}
FILE* (*DLXOpenFile)(char*)=_DefaultOpen;
void (*DLXError)(char*)=_DefaultError;
static CDLX** _dlxlist=(CDLX**)malloc(0);
static long _numdlx=0;
static void _NGucase(char *c)
{
        for (unsigned long x=0; x<strlen(c); x++)
                if((c[x]>96)&&(c[x]<123))
                        c[x]-=32;
}
void DLXLoad(char* name)
{
        _NGucase(name);
        for(long l=0; l<_numdlx; l++)
        {
                if(*_dlxlist[l]==name)
                {
                        ++*_dlxlist[l];
                        return;
                }
        }
        _numdlx++;
        _dlxlist=(CDLX**)realloc(_dlxlist, sizeof(CDLX**)*_numdlx);
        FILE* me=DLXOpenFile(name);
        _dlxlist[_numdlx-1]=new CDLX(name,me);
        fclose(me);
}
void DLXUnload(char* name)
{
        _NGucase(name);
        for(long l=0; l<_numdlx; l++)
        {
                if(*_dlxlist[l]==name)
                {
                        --*_dlxlist[l];
                        if(!_dlxlist[l])
                        {
                                delete(_dlxlist[l]);
                                _dlxlist[l]=_dlxlist[_numdlx-1];
                                _numdlx--;
                                _dlxlist=(CDLX**)realloc(_dlxlist, sizeof(CDLX**)*_numdlx);
                        }
                        return;
                }
        }
        DLXError("DLX is not loaded!");
}
void DLXImport(char* name, char** symbols)
{
        GlobalSymbols.AddExports(name,symbols);
}
CDLXImports::CDLXImports(FILE* infile, long nums)
{
        numimports=nums;
        names=(char**)malloc(sizeof(char *)*nums);
        numlocs=(long*)malloc(sizeof(long)*nums);
        relocs=(long**)malloc(sizeof(long*)*nums);
        long stlen;
        for(long l=0; l<nums; l++)
        {
                fread(&stlen, sizeof(long),1,infile);
                names[l]=(char *)malloc(stlen);
                fread(names[l],sizeof(char),stlen,infile);
                fread(&numlocs[l],sizeof(long),1,infile);
                relocs[l]=(long *)malloc(sizeof(long)*numlocs[l]);
                fread(relocs[l],sizeof(long),numlocs[l],infile);
        }
}
CDLXImports::~CDLXImports()
{
        free(numlocs);
        for(long l=0; l<numimports; l++)
        {
                free(names[l]);
                free(relocs[l]);
        }
        free(names);
}
void CDLXImports::Replace(char* data, char* name, char* placement)
{
        if(strlen(name)==0) return;
        for(long l=0; l<numimports; l++)
                if(strcmp(name, names[l])==0)
                {
                        names[l][0]=0;
                        for(long l2=0; l2<numlocs[l]; l2++)
                        {
                                *(long *)(data+relocs[l][l2])+=placement-data;
                        }
                }
}
void CDLXImports::CheckEmpty()
{
        for(long l=0; l<numimports; l++)
                if(strlen(names[l])!=0)
                {
                        DLXError("Unresolved External!");
                }
}
CDLXSymbolList::CDLXSymbolList()
{
        numdlx=0;
        names=(char **)malloc(0);
        tosymbols=(char ***)malloc(0);
}
void CDLXSymbolList::AddExports(char *name, char** tosymbol)
{
        numdlx++;
        names=(char**)realloc(names, sizeof(char *)*numdlx);
        tosymbols=(char***)realloc(tosymbols,sizeof(char**)*numdlx);
        names[numdlx-1]=(char *)malloc(strlen(name)+1);
        strcpy(names[numdlx-1],name);
        tosymbols[numdlx-1]=tosymbol;
}
void CDLXSymbolList::RemoveExports(char*name)
{
        for(long l=0; l<numdlx; l++)
                if(strcmp(name,names[l])==0)
                {
                        free(names[l]);
                        names[l]=names[numdlx-1];
                        tosymbols[l]=tosymbols[numdlx-1];
                        numdlx--;
                        names=(char**)realloc(names, sizeof(char *)*numdlx);
                        tosymbols=(char***)realloc(tosymbols,sizeof(char**)*numdlx);
                        return;
                }
        DLXError("Cannot unload named symbols!");
}
void CDLXSymbolList::Resolve(CDLXImports& ims, char* data)
{
        for(long l=0; l<numdlx; l++)
        {
                char** stemps=tosymbols[l];
                while( (**stemps) != 0)
                {
                        ims.Replace(data, stemps[0], stemps[1]);
                        stemps+=2;
                }
        }
        ims.CheckEmpty();
}
CDLX::CDLX(char* iname, FILE* infile)
{
        CDLXImports* myimps;
        instance=1;
        name=(char*)malloc(strlen(iname)+1);
        strcpy(name,iname);
        dlxheader dh;
        fread(&dh, sizeof(dh),1,infile);
        if(dh.magic!=DLX_MAGIC)
        {
                DLXError("Invalid DLX!");
                return;
        }
        libloadpos=dh.libloadpos;
        myimps=new CDLXImports(infile,dh.numimports);
        data=(char *)malloc(dh.prgsize);
        fread(data, dh.prgsize, 1,infile);
        for(long l=0; l<dh.numrelocs; l++)
        {
                long reloc;
                fread(&reloc,sizeof(long),1,infile);
                *((long *)(data+reloc))+=(long)data;
        }
        LibMain=(void(*)(int))data+dh.libmainpos;
        // export all exports...
        GlobalSymbols.AddExports(name, (char **)(data+dh.extablepos));
        // load all libraries...
        char** myptr=(char **)(data+dh.libloadpos);
        while( (**myptr) != 0)
        {
                DLXLoad(*myptr);
                myptr++;
        }
        // resolve all externals...
        GlobalSymbols.Resolve(*myimps, data);
        delete(myimps);
        // call LibMain...
        LibMain(0);
}
CDLX::~CDLX()
{
        LibMain(1);
        char** myptr=(char **)(data+libloadpos);
        while( *(int *)*myptr != 0)
        {
                DLXUnload(*myptr);
                myptr++;
        }
        GlobalSymbols.RemoveExports(name);
        free(data);
        free(name);
}
int CDLX::operator==(char*i)
{
        return (strcmp(name,i)==0);
}
int CDLX::operator!()
{
        return(instance==0);
}
int CDLX::operator++()
{
        instance++;
        LibMain(2);
}
int CDLX::operator--()
{
        instance--;
        LibMain(3);
}
