#ifndef FlatPipelineClass
#define FlatPipelineClass

#include <Lib3d/Pipeline.H>

class Light;
class Material;
class Flat_VertexData;
class Flat_NormalData;
class Flat_MaterialData;
class Flat_LightData;
class Flat_LightMaterialData;
class Flat_LightNormalData;
class Flat_MaterialNormalData;
class Flat_PolygonData;

// Hardwired with an ambient+diffuse, directional-only lighting model.

class FlatPipeline : public Pipeline
{
public:
    FlatPipeline();
    ~FlatPipeline();

    const char *getName() const { return "FlatPipeline"; }

    void registerModel( Model &);
    void render( Model &, Viewport &, const Light *, uint, uint, uint );
    
protected:
    void expand(uint nrLights);
    void cullBackFaces( );
    void calculateLightData( Viewport &, const Light *, uint );
    void calculateRGBData( Viewport &, const Light *, uint );
    void calculateIntensityData( Viewport &, const Light *, uint );
    void calculateIntensityRamps( Viewport &, const Light *, uint );
    void transform( Viewport & );
    virtual void renderPolygons( Viewport &, uint );
    virtual void cullAndRenderPolygons( Viewport &, uint );
    bool transformForClipping( Viewport & );
    virtual void clipAndRenderPolygons( Viewport &, uint );
    bool clipPolygon( const Polygon &, uint );
    uint lightPolygon( const Polygon &, Viewport &, uint  );


protected:
    typedef void (*ClipFunc)( const Vector3&, const Vector3&, Vector3& out );

protected:
    uint thisFrame;
    uint renderFlags;

    int xmin;
    int xmax;
    int ymin;
    int ymax;
    bool using_lit_normals;
    bool have_backface_info;

    uint sizeNpool;
    Flat_NormalData *npool;

    uint nrVpool;
    uint sizeVpool;
    Flat_VertexData *vpool;

    uint nrLMpool;
    uint sizeLMpool;
    Flat_LightMaterialData *lmpool;

    uint nrLNpool;
    uint sizeLNpool;
    Flat_LightNormalData *lnpool;

    uint nrMNpool;
    uint sizeMNpool;
    Flat_MaterialNormalData *mnpool;

    uint sizeMpool;
    Flat_MaterialData *mpool;


    uint nrPpool;
    uint sizePpool;
    Flat_PolygonData *ppool;

    PipelineData **pv;
    uint clipPlanes;
    uint nrClippedVertices;

    bool clip;

protected:
    static void intersectZ1( const Vector3&, const Vector3&, Vector3& );
    static void intersectZ2( const Vector3&, const Vector3&, Vector3& );
    static void intersectY1( const Vector3&, const Vector3&, Vector3& );
    static void intersectY2( const Vector3&, const Vector3&, Vector3& );
    static void intersectX1( const Vector3&, const Vector3&, Vector3& );
    static void intersectX2( const Vector3&, const Vector3&, Vector3& ); 

    static ClipFunc Intersect[];
};


// Visible for the sake of the wireframe pipeline.

class Flat_VertexData : public PipelineData {
public:
    Vector3 cvv;
    uint outcodes;
};



struct Flat_NormalData
{
    Flat_NormalData() : front(0) {}
    uint front;
    float sumDotProd;
    uint intensity;
};

struct Flat_LightMaterialData
{
    Vector3 diffuse;
};

struct Flat_LightNormalData
{
    float dotprod;
};

struct Flat_LightData
{
    Vector3 pov;	      
};

struct Flat_MaterialData
{
    Vector3 ambient;
    Colour ambientDeviceColour;
};

struct Flat_MaterialNormalData
{
    Colour colour;
};

struct Flat_PolygonData
{
    bool backface;
};


#endif











