#ifndef SmoothPipelineClass
#define SmoothPipelineClass

#include <Lib3d/Pipeline.H>

class Light;
class Material;
struct Smooth_VertexNormalData;
struct Smooth_PolygonData;
class Smooth_VertexData;


// Hardwired with an ambient+diffuse, directional-only lighting model.

class SmoothPipeline : public Pipeline
{
public:
    SmoothPipeline();
    ~SmoothPipeline();

    const char *getName() const { return "SmoothPipeline"; }

    void registerModel(Model &);
    void render(Model &, 
		Viewport &, 
		const Light *, 
		uint nrLights, 
		uint clipPlanes,
		uint flags);
    
protected:
    void cullBackFaces( );
    void calculateLightData( Viewport &, const Light *, uint );
    void transform( Viewport & );
    void renderPolygons( Viewport &, uint );
    void cullAndRenderPolygons( Viewport &, uint );
    bool transformForClipping( Viewport & );
    void clipAndRenderPolygons( Viewport &, uint );
    bool clipPolygon( const Polygon &, uint );


protected:
    typedef void (*ClipFunc)(const Smooth_VertexData&, 
			     const Smooth_VertexData&, 
			     Smooth_VertexData& out );


protected:
    uint thisFrame;
    uint renderFlags;
    bool clip;

    int xmin;
    int xmax;
    int ymin;
    int ymax;
    bool using_lit_normals;
    bool have_backface_info;

    uint sizeNpool;
    Smooth_VertexNormalData *npool;

    uint nrVpool;
    uint sizeVpool;
    Smooth_VertexData *vpool;

    uint nrPpool;
    uint sizePpool;
    Smooth_PolygonData *ppool;

    SmoothPipelineData **pv;
    uint clipPlanes;
    uint nrClippedVertices;

protected:
    static void intersectZ1(const Smooth_VertexData&, 
			    const Smooth_VertexData&, Smooth_VertexData&);
    static void intersectZ2(const Smooth_VertexData&, 
			    const Smooth_VertexData&, Smooth_VertexData&);
    static void intersectY1(const Smooth_VertexData&, 
			    const Smooth_VertexData&, Smooth_VertexData&);
    static void intersectY2(const Smooth_VertexData&, 
			    const Smooth_VertexData&, Smooth_VertexData&);
    static void intersectX1(const Smooth_VertexData&, 
			    const Smooth_VertexData&, Smooth_VertexData&);
    static void intersectX2(const Smooth_VertexData&, 
			    const Smooth_VertexData&, Smooth_VertexData&);

    static ClipFunc Intersect[];
};

#endif








