// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

#ifndef WorldBuilderClass
#define WorldBuilderClass

#include <Lib3d/internals/Debuggable.H>

// This class supports building whole hierarchies rather than individual
// models, (see ModelBuilder).  
// NFF files can contain information about a camera and one or more lights 
// as well as the actual model data.  This is probably the case with other
// file formats as well.

class World;
class istream;

class WorldBuilder : public Debuggable
{
public:
    WorldBuilder();
    ~WorldBuilder();

    World *readNff( istream & );
    const char *getName() const { return "WorldBuilder"; }
};

#endif
