// Copyright (C) 1996 Keith Whitwell.
// This file may only be copied under the terms of the GNU Library General
// Public License - see the file COPYING in the lib3d distribution.

/*
 * This file isn't really complete.  Just use generic.cc.
 */

#include "arch.H"
#include <alpha/fpu.h>
#include <iostream.h>

static unsigned long old_fpcr;

void
setup_fpu()
{

   old_fpcr = ieee_get_fp_control();

   cout << "Old fpu control was: " << (void *)old_fpcr << endl;

   ieee_set_fp_control(0);	// ignore everything.

/*
	       | _FPU_MASK_IM    // Ignore invalid instructions
	       | _FPU_MASK_DM    // Ignore denormalized operations
	       | _FPU_MASK_ZM    // Ignore divide by zero
	       | _FPU_MASK_PM    // Ignore precision errors (?)
	       | _FPU_MASK_OM    // Ignore overflow
	       | _FPU_MASK_UM    // Ignore underflow
*/

    // It is important to use low precision arithmetic internally to
    // the FPU, because we are using LP floats externally.  This way
    // we get consistent results whether or not the compiler decides
    // to leave some results sitting inside the FPU.  It is not clear
    // how to direct OSF to do this.
}

void
restore_fpu()
{
   ieee_set_fp_control(old_fpcr);
}




