/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: _convert.c,v 1.2 1996/07/13 20:55:09 jack Exp $ */

#include <stddef.h>
#include <mbprvt.h>

/* convert functions (C locale) */
wchar_t
__string_single_to_wchar_c (const char *s)
{
  return (wchar_t) *(unsigned char *) s;
}

/* dummy function */
wchar_t
__string_double_to_wchar_c (const char *s)
{
  return (wchar_t) *(unsigned char *) s;
}

int
__wchar_to_mbc_c (wchar_t wc)
{
  return (int) (unsigned char) wc;
}

/* current functions */
wchar_t (*__string_single_to_wchar) (const char *s) = __string_single_to_wchar_c;
wchar_t (*__string_double_to_wchar) (const char *s) = __string_double_to_wchar_c;
int (*__wchar_to_mbc) (wchar_t wc) = __wchar_to_mbc_c;

/* for solving undefine symbol */
static void (*__mbinit_dummy) (int, const char *) = __mbinit;
