#! /bin/sh

#
# Adjust the paths to files used in html pages
# and rename them to DOS licit names.
#
# List must be updated.
#

cd ../doc/libvorbis

# Map of file names that are illicit on DOS file system.
ILLICIT_NAMES_MAP=(
"vorbis_analysis.html             : analysis.html"
"vorbis_analysis_blockout.html    : asisblockout.html"
"vorbis_analysis_buffer.html      : asisbuffer.html"
"vorbis_analysis_headerout.html   : asisheaderout.html"
"vorbis_analysis_init.html        : asisinit.html"
"vorbis_analysis_wrote.html       : asiswrote.html"
"vorbis_bitrate_addblock.html     : brate_addblock.html"
"vorbis_bitrate_flushpacket.html  : brate_flushpacket.html"
"vorbis_block.html                : block.html"
"vorbis_block_clear.html          : block_clear.html"
"vorbis_block_init.html           : block_init.html"
"vorbis_comment.html              : comment.html"
"vorbis_comment_add.html          : cmntadd.html"
"vorbis_comment_add_tag.html      : cmntadd_tag.html"
"vorbis_comment_clear.html        : cmntclear.html"
"vorbis_comment_init.html         : cmntinit.html"
"vorbis_comment_query.html        : cmntquery.html"
"vorbis_comment_query_count.html  : cmntqry_count.html"
"vorbis_commentheader_out.html    : commentheader_out.html"
"vorbis_dsp_clear.html            : dsp_clear.html"
"vorbis_dsp_state.html            : dsp_state.html"
"vorbis_granule_time.html         : granule_time.html"
"vorbis_info.html                 : info.html"
"vorbis_info_blocksize.html       : info_blocksize.html"
"vorbis_info_clear.html           : info_clear.html"
"vorbis_info_init.html            : info_init.html"
"vorbis_packet_blocksize.html     : packet_blocksize.html"
"vorbis_synthesis.html            : synthesis.html"
"vorbis_synthesis_blockin.html    : ssisblockin.html"
"vorbis_synthesis_halfrate.html   : ssishalfrate.html"
"vorbis_synthesis_halfrate_p.html : ssishalfrate_p.html"
"vorbis_synthesis_headerin.html   : ssisheaderin.html"
"vorbis_synthesis_idheader.html   : ssisidheader.html"
"vorbis_synthesis_init.html       : ssisinit.html"
"vorbis_synthesis_lapout.html     : ssislapout.html"
"vorbis_synthesis_pcmout.html     : ssispcmout.html"
"vorbis_synthesis_read.html       : ssisread.html"
"vorbis_synthesis_restart.html    : ssisrestart.html"
"vorbis_synthesis_trackonly.html  : ssistrackonly.html"
"vorbis_version_string.html       : version_string.html"
)

# Create sed script to modify the file content.
rm script.sed
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  echo "/<a href=\"${OLD_NAME}\">/s|${OLD_NAME}|${NEW_NAME}|g" >> script.sed
done

# Rename files and change their paths.
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  sed -f script.sed ${OLD_NAME} > ${NEW_NAME}
#  dtou ${NEW_NAME}
#  diff -aU1 ${OLD_NAME} ${NEW_NAME} > ${NEW_NAME}.txt
  rm -vf ${OLD_NAME}
done


# Change illicit file names in the rest of the files.
FILES=$(echo *.html)
for FILE in ${FILES}; do
  sed -f script.sed ${FILE} > ${FILE}.txt
  dtou ${FILE}.txt
  mv -vf ${FILE}.txt ${FILE}
done

# Adjust libvorbis/Makefile.in accordingly.
cat > fix.sed << EOF
  s,^.*/s|,s|,;s/g$//
1i\\
/^doc_DATA[ 	]*=[ 	]*/,/^$/ {
\$a\\
}
EOF
sed -f fix.sed script.sed > script.txt
sed -f script.txt Makefile.in > makefile.txt
dtou Makefile.txt
mv -vf Makefile.txt Makefile.in

rm -f script.sed script.txt fix.sed


cd ../vorbisenc

# Map of file names that are illicit on DOS file system.
ILLICIT_NAMES_MAP=(
"ovectl_ratemanage_arg.html       : rtmnge_arg.html"
"ovectl_ratemanage2_arg.html      : rtmnge2_arg.html"

"vorbis_encode_ctl.html           : ctl.html"
"vorbis_encode_init.html          : init.html"
"vorbis_encode_init_vbr.html      : init_vbr.html"
"vorbis_encode_setup_init.html    : setup_init.html"
"vorbis_encode_setup_managed.html : setup_managed.html"
"vorbis_encode_setup_vbr.html     : setup_vbr.html"
)

# Create sed script to modify the file content.
rm script.sed
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  echo "/<a href=\"${OLD_NAME}\">/s|${OLD_NAME}|${NEW_NAME}|g" >> script.sed
done

# Rename files and change their paths.
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  sed -f script.sed ${OLD_NAME} > ${NEW_NAME}
#  dtou ${NEW_NAME}
#  diff -aU1 ${OLD_NAME} ${NEW_NAME} > ${NEW_NAME}.txt
  rm -vf ${OLD_NAME}
done


# Change illicit file names in the rest of the files.
FILES=$(echo *.html)
for FILE in ${FILES}; do
  sed -f script.sed ${FILE} > ${FILE}.txt
  dtou ${FILE}.txt
  mv -vf ${FILE}.txt ${FILE}
done

# Adjust vorbisenc/Makefile.in accordingly.
cat > fix.sed << EOF
  s,^.*/s|,s|,;s/g$//
1i\\
/^doc_DATA[ 	]*=[ 	]*/,/^$/ {
\$a\\
}
EOF
sed -f fix.sed script.sed > script.txt
sed -f script.txt Makefile.in > makefile.txt
dtou Makefile.txt
mv -vf Makefile.txt Makefile.in

rm -f script.sed script.txt fix.sed


cd ../vorbisfile

# Map of file names that are illicit on DOS file system.
ILLICIT_NAMES_MAP=(
"ov_bitrate.html            : bitrate.html"
"ov_bitrate_instant.html    : bitrate_instant.html"
"ov_callbacks.html          : callbacks.html"
"ov_clear.html              : clear.html"
"ov_comment.html            : comment.html"
"ov_crosslap.html           : crosslap.html"
"ov_fopen.html              : fopen.html"
"ov_info.html               : info.html"
"ov_open.html               : open.html"
"ov_open_callbacks.html     : open_callbacks.html"
"ov_pcm_seek.html           : pcm_seek.html"
"ov_pcm_seek_lap.html       : psk_lap.html"
"ov_pcm_seek_page.html      : psk_page.html"
"ov_pcm_seek_page_lap.html  : psk_page_lap.html"
"ov_pcm_tell.html           : pcm_tell.html"
"ov_pcm_total.html          : pcm_total.html"
"ov_raw_seek.html           : raw_seek.html"
"ov_raw_seek_lap.html       : rawseek_lap.html"
"ov_raw_tell.html           : raw_tell.html"
"ov_raw_total.html          : raw_total.html"
"ov_read.html               : read.html"
"ov_read_filter.html        : read_filter.html"
"ov_read_float.html         : read_float.html"
"ov_seekable.html           : seekable.html"
"ov_serialnumber.html       : serialnumber.html"
"ov_streams.html            : streams.html"
"ov_test.html               : test.html"
"ov_test_callbacks.html     : test_callbacks.html"
"ov_test_open.html          : test_open.html"
"ov_time_seek.html          : time_seek.html"
"ov_time_seek_lap.html      : tsklap.html"
"ov_time_seek_page.html     : tskpage.html"
"ov_time_seek_page_lap.html : tskpage_lap.html"
"ov_time_tell.html          : time_tell.html"
"ov_time_total.html         : time_total.html"
)

# Create sed script to modify the file content.
rm script.sed
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  echo "/<a href=\"${OLD_NAME}\">/s|${OLD_NAME}|${NEW_NAME}|g" >> script.sed
done

# Rename files and change their paths.
for NAME_PAIR in "${ILLICIT_NAMES_MAP[@]}"; do
  OLD_NAME=$(echo ${NAME_PAIR} | sed "s|[ ]\+: .*$||")
  NEW_NAME=$(echo ${NAME_PAIR} | sed "s|^.* : ||")
  sed -f script.sed ${OLD_NAME} > ${NEW_NAME}
#  dtou ${NEW_NAME}
#  diff -aU1 ${OLD_NAME} ${NEW_NAME} > ${NEW_NAME}.txt
  rm -vf ${OLD_NAME}
done


# Change illicit file names in the rest of the files.
FILES=$(echo *.html)
for FILE in ${FILES}; do
  sed -f script.sed ${FILE} > ${FILE}.txt
  dtou ${FILE}.txt
  mv -vf ${FILE}.txt ${FILE}
done

# Adjust vorbisfile/Makefile.in accordingly.
cat > fix.sed << EOF
  s,^.*/s|,s|,;s/g$//
1i\\
/^doc_DATA[ 	]*=[ 	]*/,/^$/ {
\$a\\
}
EOF
sed -f fix.sed script.sed > script.txt
sed -f script.txt Makefile.in > makefile.txt
dtou Makefile.txt
mv -vf Makefile.txt Makefile.in

rm -f script.sed script.txt fix.sed
