/*
    Copyright (c) 2004-2005, Jeremy Cole and others

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "mygis.h"
#include "geometry.h"
#include "wkb/wkb.h"
#include "wkt/wkt.h"

#include <stdio.h>
#include <stdlib.h>

/* POINT(1 1) */
static char point_1[21] = {
  0x01, /* byte order */
  0x01, 0x00, 0x00, 0x00,  /* type: 1, point */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F
};

/* POINT(50.235 -42.456) */
static char point_2[21] = { 
  0x01, /* byte order */
  0x01, 0x00, 0x00, 0x00, /* type: 1, point */
  0xAE, 0x47, 0xE1, 0x7A, 0x14, 0x1E, 0x49, 0x40,
  0xEE, 0x7C, 0x3F, 0x35, 0x5E, 0x3A, 0x45, 0xC0
};

/* LINESTRING(1 1, 50.235 -42.456) */
static char linestring_1[41] = {
  0x01, /* byte order */
  0x02, 0x00, 0x00, 0x00, /* type: 2, linestring */
  0x02, 0x00, 0x00, 0x00, /* length: 2 points */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
  0xAE, 0x47, 0xE1, 0x7A, 0x14, 0x1E, 0x49, 0x40,
  0xEE, 0x7C, 0x3F, 0x35, 0x5E, 0x3A, 0x45, 0xC0
};

/* POLYGON((1 1, -1 1, -1 -1, 1 -1, 1 1)) */
static char polygon_1[93] = {
  0x01, /* byte order */
  0x03, 0x00, 0x00, 0x00, /* type: 3, polygon */
  0x01, 0x00, 0x00, 0x00, /* linearrings: 1 */
  0x05, 0x00, 0x00, 0x00, /* length: 5 points */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F
};

static char combo[155] = {
  /* POINT(50.235 -42.456) */
  0x01,
  0x01, 0x00, 0x00, 0x00,
  0xAE, 0x47, 0xE1, 0x7A, 0x14, 0x1E, 0x49, 0x40,
  0xEE, 0x7C, 0x3F, 0x35, 0x5E, 0x3A, 0x45, 0xC0,

  /* LINESTRING(1 1, 50.235 -42.456) */
  0x01,
  0x02, 0x00, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
  0xAE, 0x47, 0xE1, 0x7A, 0x14, 0x1E, 0x49, 0x40,
  0xEE, 0x7C, 0x3F, 0x35, 0x5E, 0x3A, 0x45, 0xC0,

  /* POLYGON((1 1, -1 1, -1 -1, 1 -1, 1 1)) */
  0x01,
  0x03, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xBF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F
};

int main(int argc, char **argv) {
  WKB *wkb;
  GEOMETRY *geo;
  char *test[6] = { point_1, point_2, linestring_1, polygon_1, combo, NULL };
  int size[6] = { 21, 21, 41, 93, 155, 0 };  
  char **p;
  int *s;

  DBUG_ENTER("main");
  DBUG_PROCESS(argv[0]);
  DBUG_PUSH("d:t");

  wkb = wkb_init(0);
  for(p=test, s=size; *p; p++, s++) {
    if(wkb_load(wkb, *p, *s, WKB_F_DUPE) != 0) {
      fprintf(stderr, "Couldn't load WKB.\n");
      exit(1);
    }
    while( (geo = wkb_read_next(wkb)) ) {
      geometry_dump(geo, 5);
      geometry_free(geo);
    };
  };
  wkb_free(wkb);

  DBUG_RETURN(0);
}
