/* -*- coding: cp852 -*-

  DJGPP Socket Wrapper for Microsoft Network Client  
  written by Tomasz Zbroek (2007/2008) / UPOS System Sp. z o.o.
  Released to the Public Domain.
  
*/

#include <dpmi.h>
#include <go32.h>
#include <string.h>
#include "basmac.h"
#include "drventry.h"
#include "result.h"

static enum EDriverMode eDriverMode = eDriverMode_Open;

static word wStatus = 1; //data8

#define PATHLEN 100

/****************************************************************/
/** Driver exit
 */
void DriverExit() 
{
  eDriverMode = eDriverMode_Open;
}

/****************************************************************/
/** Get MS Client status
 */
int GetStatus(struct SCommand * i_pCmd, word *o_pErrNo)
{
  int nResult;
  struct SCommand sCmd;

  if(i_pCmd != NULL)
    sCmd = *i_pCmd;

  sCmd.yCmd = eCmd_GetStatus;

  nResult = DriverEntry(&sCmd, o_pErrNo);
  
  return nResult;
}

/****************************************************************/
/**  
 */
int CheckBinaryCompability(struct SCommand *i_pCmd, word *o_pErrNo)
{
  int nResult = 0;
  if(wStatus)
    {
      nResult = LocaterSend(i_pCmd, o_pErrNo);
    }
  else
    {
      *o_pErrNo = eErrNo_VersionMismatch;
      return -1;
    }
  return nResult;
}

/****************************************************************/
/** Open driver
 */
int DriverOpen(struct SCommand *i_pCmd, word *o_pErrNo)
{
  dword dwValue;
  short nResult;
  word wErrNo;
  word wResult;
  struct SCommand sCmd;

  if(!LocaterOpen())
    {
      *o_pErrNo = eErrNo_NetworkingSubsystemNotStarted;
      return -1;
    }

  if(!LocaterBind("SO", &dwValue, &wResult) || 
     wResult)
    {
      *o_pErrNo = eErrNo_NetworkingSubsystemNotStarted; 
      return -1;
    }
  
  if(!LocaterUnbind("SO", &wResult) || 
     wResult)
    {
      *o_pErrNo = eErrNo_NetworkingSubsystemNotStarted;
      return -1;
    }

  eDriverMode = eDriverMode_Send;

  sCmd.wParam1 = 0;
  sCmd.wParam2 = 0;
  sCmd.wParam3 = 3; // MsClient Version ?  

  nResult = GetStatus(&sCmd, &wErrNo);
  if(nResult < 0)
    return nResult;
  
  eDriverMode = eDriverMode_CheckBinaryCompability;

  if(nResult == 0)
    {
      wStatus = sCmd.wParam3;
      nResult = DriverEntry(i_pCmd, &wErrNo);
      if(nResult < 0)
        {
          *o_pErrNo = wErrNo;
          return nResult;
        }
    }
  else
    {
      *o_pErrNo = wErrNo;      
    }

  return nResult;
}

/****************************************************************/
/** @todo unfinished 
 */
const char * GetNetFilesPath()
{
  word wResult = 0;
  word wErrNo = 0;
  const char szDefaultPath[] = "c:/etc";
  static char szPath[PATHLEN] = "";

  if(strlen(szPath) == 0)
    {
      dword dwDosBuf;
      struct SCommand sCmd;
      //sCmd.wParam1 = sDosTmpBuf.rm_offset;
      //sCmd.wParam2 = sDosTmpBuf.rm_segment;
      //dwDosBuf = sDosTmpBuf.rm_segment * 16 + sDosTmpBuf.rm_offset;
  
      dosmemput(szPath, sizeof(szPath), dwDosBuf);
    
      if(GetStatus(&sCmd, &wErrNo) < 0)
        return NULL;

      if(wResult)
        {
          strcpy(szPath, szDefaultPath);
        }
      else
        {
          dosmemget(dwDosBuf, sizeof(szPath), szPath);
        }
    }

  return (const char *) &szPath;
}

/****************************************************************/
/** @todo unfinished 
 */
const char * SetServent()
{
  const char *pPath;
  pPath = GetNetFilesPath();
  return pPath;

}

/****************************************************************/
/** Driver entry
 */
int DriverEntry(struct SCommand *i_pCmd, word *o_pErrNo)
{
  int nResult = 0;
  switch(eDriverMode)
    {
    case eDriverMode_Open:
      nResult = DriverOpen(i_pCmd, o_pErrNo);
      break;
    case eDriverMode_Send:
      nResult = LocaterSend(i_pCmd, o_pErrNo);
      break;
    case eDriverMode_CheckBinaryCompability:
      nResult = CheckBinaryCompability(i_pCmd, o_pErrNo);
      break;
    default:
      break;
    }

  return nResult;
}

