/* -*- coding: cp852 -*- */
/** Select Test
 * by Tomasz Zbroek
 * PUBLIC DOMAIN
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <conio.h>
#include <netinet/in.h>
#include <sys/socket.h>

#define BUFFER_SIZE 2048

void errorlog(char *i_pName)
{
  FILE *fp;
  int nErrNo = errno;
  fp = fopen("select.log","a");
  if(fp != NULL)
    {
      fprintf(fp, "%s, errno=%d, %s\n", i_pName, nErrNo, sock_strerror(nErrNo));
      fclose(fp);
    }
}

void FdSet(int nSocket, fd_set * pFd)
{
  FD_SET(nSocket % MAX_SOCKETS, pFd);  
}

void FdClr(int nSocket, fd_set * pFd)
{
  FD_CLR(nSocket % MAX_SOCKETS, pFd);  
}

int FdIsSet(int nSocket, fd_set * pFd)
{
  return FD_ISSET(nSocket % MAX_SOCKETS, pFd);  
}

void Test(const char *i_pAddr, const char *i_pPort)
{
  int nRes;
  int nSocket = 0;
  int nNewSocket = 0;
  fd_set sFdMask;
  char szHost[254];
  struct sockaddr_in sAddr;

  nSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
  if(nSocket < 0)
    {
      errorlog("socket");
      return;
    }

  gethostname(szHost, 254);
  
  printf("TCP Port      : %s\n", i_pPort);
  printf("Host name     : %s\n", szHost);

  {
    int nMode = 1; //nonblocking mode
    nRes = ioctl(nSocket, FIONBIO, &nMode);
    if(nRes < 0)
      {
        errorlog("ioctl");
        close_socket(nSocket);
        return;
      }
  }

  memset((void *) &sAddr, 0, sizeof(sAddr));
  sAddr.sin_family = AF_INET;
  sAddr.sin_addr.s_addr = INADDR_ANY;
  sAddr.sin_port = htons(atoi(i_pPort)); 
  
  nRes = bind(nSocket, &sAddr, sizeof(sAddr));
  if(nRes < 0)
    {                                                                   
      errorlog("bind");
      close_socket(nSocket);
      return;
    }

  nRes = listen(nSocket, SOMAXCONN);
  if(nRes < 0)
    {
      errorlog("listen");
      close_socket(nSocket);
      return;
    }

  FD_ZERO(&sFdMask);
  FdSet(nSocket, &sFdMask);

  while(!kbhit())
    {
      int i;
      int j;
      int nFound;
      int nMaxFd = 0;
      struct timeval tv;      
      char aBuffer[BUFFER_SIZE];

      fd_set sFdRead = sFdMask;
      fd_set sFdExcept = sFdMask;
      
      for(j = 0; j < FD_MASK; j++)
        {
          if(sFdRead.fd_bits[j] == 0)
            continue;

          for(i = 0; i < 8 && (i + j*8 < MAX_SOCKETS); i++)
            {
              if(sFdRead.fd_bits[j] & (1 << i))
                nMaxFd = i + j*8 + 1;
            }
        }

      tv.tv_sec = 0;
      tv.tv_usec = 0;

      nFound = select(nMaxFd, &sFdRead, NULL, &sFdExcept, &tv);
      if(nFound == -1)
        {
          errorlog("select");
          continue;
        }

      if(nFound == 0)
        {
          continue;
        }

      if (nFound == 3)	// connection loss
        {
          close_socket(nNewSocket);
          FD_ZERO(&sFdMask);
          FdSet(nSocket, &sFdMask);
        }

      if (FdIsSet(nSocket, &sFdRead))
        {
          struct sockaddr_in sRemote;
          int nAddrLen = sizeof sRemote;

          if(nMaxFd > 1)
            {
              close_socket(nNewSocket);
              FD_ZERO(&sFdMask);
              FdSet(nSocket, &sFdMask);
            }

          nNewSocket = accept(
                              nSocket,
                              (struct sockaddr*)&sRemote,
                              &nAddrLen
                              );

          if(nNewSocket < 0)
            {
              errorlog("accept");
              continue;
            }

          printf("New connection: %s:%d\n",
                 inet_ntoa(sRemote.sin_addr),
                 ntohs(sRemote.sin_port)
                 );

          FdSet(nNewSocket, &sFdMask);
          FdClr(nSocket, &sFdRead);
        }

      if (FdIsSet(nNewSocket, &sFdRead))
        {
          int nIoctlData = 0; // received data length
          nRes = ioctl(nNewSocket, FIONREAD, &nIoctlData);
          if (nRes < 0)
            {
              errorlog("ioctl");
              continue;
            }

          if (nIoctlData == 0)
            {
              if (nFound == 1)
                {
                  close_socket(nNewSocket);
                  FD_ZERO(&sFdMask);
                  FdSet(nSocket, &sFdMask);
                }
            }
          else
            {
              if (nIoctlData > 0)
                {
                  if (nIoctlData >= BUFFER_SIZE)
                    {
                      close_socket(nNewSocket);
                      FD_ZERO(&sFdMask);
                      FdSet(nSocket, &sFdMask);
                      continue;
                    }

                  nRes = recv(nNewSocket, (char *) &aBuffer, nIoctlData, 0);
                  if(nRes == -1)
                    {
                      errorlog("recv");
                    }
                  else
                    {
                      aBuffer[nRes] = 0;
                      printf("received: %s\n", aBuffer);

                      {
                        const char aMsg[] = "Hello from DJGPP!";
                        nRes = send(nNewSocket, (char *) aMsg, strlen(aMsg), 0);
                        if(nRes < 0)
                          {
                            errorlog("send");
                            close_socket(nNewSocket);
                            close_socket(nSocket);
                            return;
                          }
                      }

                    }

                }
              else
                {
                  printf("empty data received\n");
                }
            }
        }
    }

  if(nNewSocket)
    close_socket(nNewSocket);
  if(nSocket)
    close_socket(nSocket);
}


int main(int argc, char *argv[])
{
  int nRes;

  const char aPort[] = "23";
  const char aAddr[] = "192.168.0.49";

  const char *pPort = NULL;
  const char *pAddr = NULL;

  if(argc > 1)
    pPort = argv[1];
  if(argc > 2)
    pAddr = argv[2];
  
  printf("Select Test for DJGPP MSClient wrapper\n");
  if(argc > 1) 
    if(strcmp(argv[1], "-h")==0)
      {
        printf("select.exe <PORT> <ADDRESS>\n\n");
        return 0;
      }

  if(pPort == NULL)
    pPort = aPort;
  if(pAddr == NULL)
    pAddr = aAddr;

  Test(pAddr, pPort);

  return 0;
}

