/* -*- coding: cp852 -*- */
/** Windows SendTo Test
 * by Tomasz Zbroek
 * PUBLIC DOMAIN
 */

#include <stdio.h>
#include <string.h>
#include <windows.h>
#include <winsock.h>
#include <errno.h>

void Test(const char *i_pAddr, const char *i_pPort)
{
  int nRes;
  int nSocket;
  struct sockaddr_in saServer;
  char szHost[254];
  const char szMsg[] = "Hello from Windows";

  nSocket = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
  if(nSocket < 0)
    {
      printf("socket() error, res=%d, err=%d\n", nSocket, errno);
      return;
    }

  gethostname(szHost, 254);
  
  printf("UDP Port      : %s\n", i_pPort);
  printf("Host name     : %s\n", szHost);

  saServer.sin_family = AF_INET;          
  saServer.sin_port = htons(atoi(i_pPort));
  saServer.sin_addr.s_addr = inet_addr(i_pAddr);
  memset(saServer.sin_zero, '\0', sizeof saServer.sin_zero);

  nRes = sendto(nSocket, (char *) szMsg, strlen(szMsg), 0, (struct sockaddr *)&saServer, sizeof(saServer));
  if(nRes < 0)
    {
      printf("sendto() error, res=%d, err=%d\n", nSocket, errno);
      closesocket(nSocket);
      return;
    }

  closesocket(nSocket);
}

int main(int argc, char *argv[])
{
  int nRes;

  const char aPort[] = "23";
  const char aAddr[] = "192.168.0.91";

  const char *pPort = NULL;
  const char *pAddr = NULL;

  if(argc > 1)
    pPort = argv[1];
  if(argc > 2)
    pAddr = argv[2];
  
  printf("sendto Test\n");
  if(argc > 1) 
    if(strcmp(argv[1], "-h")==0)
      {
        printf("sendto.exe <PORT> <ADDRESS>\n\n");
        return 0;
      }

  if(pPort == NULL)
    pPort = aPort;
  if(pAddr == NULL)
    pAddr = aAddr;

  WSADATA wsaData;
  WORD wVersionRequested;
  wVersionRequested = MAKEWORD( 2, 2 );
 
  if(WSAStartup(wVersionRequested, &wsaData))
    {
      printf("Socket startup error\n");
      return 0;
    }

  Test(pAddr, pPort);

  WSACleanup();

  return 0;
}
