/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
            Copyright (c)1995,1996 Malcolm Taylor

 -> SCROLWIN.H
 -> ScrollingWindow class for windows with sliders.
*/

#ifndef _scrolwin_h
#define _scrolwin_h

#include <types.h>
#include <tws/window.h>
#include <tws/slider.h>

#define ID_HORIZONTAL_SLIDER  2000
#define ID_VERTICAL_SLIDER    2001


class ScrollingWindow:public Window {
   public:
      ScrollingWindow(Window*,const char*,int,int,int,int,int);
      ~ScrollingWindow();

      void ChangeSize(int w,int h);

   protected:
      void ScrollUp();
      void ScrollDown();
      void ScrollLeft();
      void ScrollRight();
      void PageUp();
      void PageDown();
      void PageLeft();
      void PageRight();
      void VSliderMove(int);
      void HSliderMove(int);

      virtual void MoveVertical(int);
      virtual void MoveHorizontal(int);

      int vw,vh;        // Virtual width and height.
      int xo,yo;        // The position of the top corner on the virtual buffer.

      VSlider *vslider;
      HSlider *hslider;

      DECLARE_RESPONSE_TABLE;
};



#endif
