/*************************************************************
 *****************    ===FONTVIEW.EXE===    ******************
 *************************************************************
		Copyright (c)1996 Grafik Software by Malcolm Taylor

 -> FONTVIEW.CC
 -> Main program source file.
*/

#include "fontview.h"
#include "fontwin.h"
#include <tws/message.h>
#include <tws/filedlg.h>
#include <tws/help.h>

extern char *ErrorString;
HelpDataBase *help_data;

DEFINE_RESPONSE_TABLE(MainMenu,AutoMenu)
	E_COMMAND(ID_FILE_OPEN,CmFileOpen)
	E_COMMAND(ID_SHELL_TO_DOS,CmFileShellToDos)
	E_COMMAND(ID_FILE_EXIT,CmFileExit)
	E_COMMAND(ID_HELP_CONTENTS,CmHelpContents)
END_RESPONSE_TABLE

void
MainMenu::CmFileOpen()
{
	char *filename;
	filename=FileDlg("Open File").Run();
	if(filename)
	{
		ViewFont(filename);
		delete filename;
	}
}

void
MainMenu::CmFileShellToDos()
{
	ws.ShellToDos();
}

void
MainMenu::CmFileExit()
{
	ws.StopRunningEvents();
}

void
MainMenu::CmHelpContents()
{
	HelpWindow *temp=new HelpWindow(NULL,help_data,"Contents",ws.GetDeskWidth()/2+10,100,ws.GetDeskWidth()*9/10+30,ws.GetDeskHeight()*4/5+50);
	temp->Setup();
}

int main(int argc,char *argv[])
{
	char *temp;

	ws.Init("fontview.cfg");

	temp=ws.GetConfigItem("help_file_name");
	if(temp==NULL)
		Error("Help file name not found in config file.");
	help_data=new HelpDataBase(temp);

	MainMenuWindow Main;

	ws.RefreshDesktop();

	ws.RunEvents();

	return 0;
}

