#
# Makefile include file for rsxnt
#
# Default: Dual mode, no Crt Dll, Optimize
#
# Call 'make crt=1' to use the C runtime dll
# Call 'make multi=1' to build multithread app / use multithread dll
# Call 'make rsx=1' to build Console win32 /rsx programs
# Call 'make debug=1' to include debug info
#

ifdef crt
ifdef multi
GCCFLAGS= -Zwin32 -Zmt -Zcrtdll
else
GCCFLAGS= -Zwin32 -Zcrtdll
endif
else  # not crt
ifdef multi
GCCFLAGS= -Zwin32 -Zmt
else
GCCFLAGS= -Zwin32
endif
endif # crt

ifdef debug
CFLAGS	= -Wall -g
ifdef rsx
LDFLAGS = -g -Zrsx32
else
LDFLAGS = -g
endif
else
CFLAGS	= -Wall -O
ifdef rsx
LDFLAGS = -Zrsx32
else
LDFLAGS =
endif
endif

CC	= gcc $(GCCFLAGS)
RC	= grc
RCFLAGS = -r
RES	= rsrc
RESFLAGS=
IMPLIB	= makelib
DLLFLAGS= -Zdll

.o.exe:
	$(CC) $(LDFLAGS) -o $*.exe $<

.c.o:
	$(CC) -c $(CFLAGS) $<

.cpp.o:
	$(CC) -c $(CFLAGS) $<

.cc.o:
	$(CC) -c $(CFLAGS) $<

.rc.res:
	$(RC) $(RCFLAGS) $<
