// Associated include file : Tools\Phases.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"
#include "tools/wintools.h"
#include "tools/phases.h"

// Local vars

static boolean GraphicPhasesON;

//---------------------------------------------------------------------------
// TPhaseWindow : Fenetre d'affichage des phases

DEFINE(TPhaseWindow);

short RegTPhaseWindow;
char *IdentTPhaseWindow = "TPhaseWindow";

TPhaseWindow::TPhaseWindow()
{ Defaults();
}

TPhaseWindow::TPhaseWindow(char *Name)
{ Defaults();
  Init(Name);
}

void TPhaseWindow::Defaults(void)
{ // Object identification
  Register=RegTPhaseWindow;
  Ident=IdentTPhaseWindow;
  // Other default values
}

void TPhaseWindow::Init(char *Name)
{ // Herited constructions
  TToolWindow::Init(200,90,"Execution...");
  // New constructions
  Insert(new TStaticText(10, 31, 180, 15, Name));
  Insert(Gauge=new TGauge(10, 60, 180, 20));
}

void TPhaseWindow::SetValue(int V)
{ Gauge->SetValue(V);
}

//---------------------------------------------------------------------------
// Variables locales

#define MaxPhaseWindows 20

static int           NbPhaseWindows;
static TPhaseWindow *PhaseWindows[MaxPhaseWindows];

//---------------------------------------------------------------------------
// Utilisation des phases d'excution

void BeginPhase(char *Name)
{ if (NbPhaseWindows==MaxPhaseWindows)
  { // Erreur : plus de phases disponibles
  }
  if (GraphicPhasesON)
  { PhaseWindows[NbPhaseWindows]=new TPhaseWindow(Name);
    Desktop->Insert(PhaseWindows[NbPhaseWindows]);
    Desktop->ShowDrawingNow();
  }
  NbPhaseWindows++;
}

void AvancePhase(int Avance)
{ if (NbPhaseWindows==0)
  { // Erreur : aucune phase en cours
  }
  if (GraphicPhasesON)
  { PhaseWindows[NbPhaseWindows-1]->SetValue(Avance);
    Desktop->ShowDrawingNow();
  }
}

void EndPhase(void)
{ if (NbPhaseWindows==0)
  { // Erreur : aucune phase en cours
  }
  NbPhaseWindows--;
  if (GraphicPhasesON)
  { delete PhaseWindows[NbPhaseWindows];
    Desktop->ShowDrawingNow();
    if (NbPhaseWindows==0) Desktop->SetCommand(cmUpdateMouse);
  }
}

//---------------------------------------------------------------------------
// Init/Done de l'unit PHASE

void InitPhases(void)
{ NbPhaseWindows=0;
  GraphicPhasesON=FALSE;
}

void DonePhases(void)
{
}

void ActivateGraphicPhases(void)
{ GraphicPhasesON=TRUE;
}