UNIT Disk;

INTERFACE

Const
     stCreate     = $0001;
     stOpen       = $0002;
     stDebut      = 0;
     stCourant    = 1;
     stFin        = 2;
     erOuverture  = $0001;
     erEcriture   = $0002;
     erLecture    = $0004;
     erFermeture  = $0008;
     erRecherche  = $0010;

Type PDisk    = ^TDisk;
     TDisk    = Object
                  Handle : Word;
                  Error  : Word;
                  GetPos : LongInt;
                  Constructor Init(Nom : String ; Acces : Word);
                  Destructor  Done;
                  Procedure   Write(Var Buf ; Taille : Word);
                  Procedure   Read(Var Buf ; Taille : Word);
                  Procedure   Seek(Depl : LongInt ; Mode : Byte);
                End;

IMPLEMENTATION

Uses Dos;

Var Reg : Registers;

Constructor TDisk.Init(Nom : String ; Acces : Word);
Begin
  Error:=0;
  Nom:=Nom+#0;
  Case Acces Of
    stCreate : Begin
                 Reg.AH:=$3C;          { Crer ou vider fichier            }
                 Reg.CX:=0;            { Attribut fichier : fichier normal }
               End;
    stOpen   : Begin
                 Reg.AH:=$3D;          { Ouvrir fichier existant           }
                 Reg.AL:=2;            { Mode d'accs : Lit/Ecrit          }
               End;
  End;
  Reg.DS:=Seg(Nom[1]);                 { Adresse du non ASCII-Z            }
  Reg.DX:=Ofs(Nom[1]);
  Intr($21,Reg);                       { Invoque le DOS                    }
  If (Reg.Flags AND FCarry)<>0 Then Inc(Error,erOuverture);
  Handle:=Reg.AX;                      { Recupre le Handle du fichier     }
  GetPos:=0;
End;

Destructor TDisk.Done;
Begin
  If (Error AND erOuverture)<>0 Then Exit;
  Reg.AH:=$3E;                         { Fonction : fermer le fichier       }
  Reg.BX:=Handle;                      { Donne le Handle du fichier         }
  Intr($21,Reg);                       { Invoque le DOS                     }
  If (Reg.Flags AND FCarry)<>0 Then Inc(Error,erFermeture);
End;

Procedure TDisk.Write(Var Buf ; Taille : Word);
Begin
  If (Error AND erOuverture)<>0 Then Exit;
  Reg.AH:=$40;                         { Ecrire dans fichier               }
  Reg.BX:=Handle;                      { Donne le Handle du fichier        }
  Reg.CX:=Taille;                      { Nombre d'octets  crire          }
  Reg.DS:=Seg(Buf);                    { Adresse de la destination         }
  Reg.DX:=Ofs(Buf);
  Intr($21,Reg);                       { Invoque le DOS                    }
  GetPos:=GetPos+Taille;
  If ((Reg.Flags AND FCarry)<>0) OR (Reg.AX<>Taille) Then Inc(Error,erEcriture);
End;

Type PTab = ^TTab;
     TTab = Array[0..65000] Of Char;

Procedure TDisk.Read(Var Buf ; Taille : Word);
Begin
  If (Error AND erOuverture)<>0 Then Exit;
  Reg.AH:=$3F;                         { Lire le fichier                   }
  Reg.BX:=Handle;                      { Donne la Handle du fichier        }
  Reg.CX:=Taille;                      { Nombre d'octets  lire            }
  Reg.DS:=Seg(Buf);                    { Adresse de la destination         }
  Reg.DX:=Ofs(Buf);
  Intr($21,Reg);                       { Invoque le DOS                    }
  GetPos:=GetPos+Taille;
  If (Reg.AX<Taille) Then
  Begin { Si lecture incomplte place un caractre EOF aprs fin fichier }
    PTab(@Buf)^[Reg.AX]:=#26;
  End;
  If ((Reg.Flags AND FCarry)<>0) OR (Reg.AX<>Taille) Then Inc(Error,erLecture);
End;

Procedure TDisk.Seek(Depl : LongInt ; Mode : Byte);
Type LongRec = Record
                 Faible : Word;
                 Fort   : Word;
               End;
Begin
  If (Error AND erOuverture)<>0 Then Exit;
  Reg.AH:=$42;
  Reg.AL:=Mode;
  Reg.BX:=Handle;
  Reg.CX:=LongRec(Depl).Fort;
  Reg.DX:=LongRec(Depl).Faible;
  Intr($21,Reg);
  Case Mode Of
    stDebut   : GetPos:=Depl;
    stCourant : GetPos:=GetPos+Depl;
    stFin     : ;
  End;
  If (Reg.Flags AND FCarry)<>0 Then Inc(Error,erRecherche);
End;

END.