/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Image manipulation ToolBox
	File      : Include/ToolBox/Image/ImgFile.H
	ErrNos    : 5000..5099
	Author    : Cedric JOULAIN, Eric NICOLAS
	Overview  : TImage Object
	UpDate    : Mar 13, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _TOOLBOX_IMAGE_IMGFILE_H_
#define _TOOLBOX_IMAGE_IMGFILE_H_

// Support for file-formats :
//    JPG, BMP, GIF, TGA, PPM, RLE

#define erImageFormatNotSupported 5000

extern short RegTImge;
extern char *IdentTImage;

class TImage : public TScreenBitmap
{ DECLARE(TImage);
  // -- Datas
  public:
    byte      *R, *G, *B;
  // -- Methods
  public:
    // Public constructors
            TImage();
            TImage(int Width, int Height);
    // Creation / Destruction
            void Defaults(void);
            void Init(int Width, int Height);
    virtual void FreeMemory(void);
    virtual void GetMemory(void);
    // File access
            void Load(char *Name);
            void Save(char *Name);
    // Screen functions
            void RawToScreen(void);
  protected:
            void LoadJPEG(TDisk *file);
            void LoadOtherFormat(TDisk *file);
};

#endif // _TOOLBOX_IMAGE_IMGFILE_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   20/02/96 :EN: First History remark. Copying code V2.00->V2.10
**                 Adding Execution Phases. Managing images of any size.
**   22/02/96 :EN: Now TImageFile came from TScreenBitmap
**   28/02/96 :EN: Adding the Defaults() method
**   02/03/96 :EN: Integrating TImage object in object database
** ------------------------------------------------------------------------*/
