#ifdef TCPDEB /*debug*/
#include <stdio.h>
#endif

/* FRAGSUPPORT enables support for packet reassembly of fragmented packets */
#define FRAGSUPPORT

#include <copyright.h>
#include <wattcp.h>
#include <elib.h>
#include <string.h>
#include <stdlib.h>

#include <dpmi.h>

#define REALBUF       5
#define MAXBUFS       5         /* maximum number of Ethernet buffers */
#define BUFSIZE    2100
#define SBUFSIZE   2100

#define SIZEPAR(x)    (((x)+15) >> 4)

#define INT_FIRST 0x60
#define INT_LAST  0x80

#define PD_DRIVER_INFO  0x1ff
#define PD_ACCESS       0x200
#define PD_RELEASE      0x300
#define PD_SEND         0x400
#define PD_GET_ADDRESS  0x600
#define CARRY           1            /* carry bit in flags register */

word _pktipofs = 0;                     /* offset from header to start of pkt */
word pkt_interrupt;

word pkt_ip_type =  0x0008;             /* these are intelled values */
word pkt_arp_type = 0x0608;

byte pktbuf[MAXBUFS][BUFSIZE+2];
/* in buf first byte is busy flag, 2nd spare */

byte pktasm[] = 
#include "pktasm.inc"
;

word  pkt_ip_handle;
word  pkt_arp_handle;

byte eth_addr[6] ;
char pkt_line[] = "PKT DRVR";

_go32_dpmi_seginfo seg_info;
_go32_dpmi_registers regs;

#define IP_DF       0x0040      /* Don't fragment bit set for FRAG Flags */
#define IP_NF       0x0020      /* Next frag, in intel form */
#define IP_OF       0xFF1F      /* frag off. in intel form */

/* forwards and externs */
byte *fragment( in_Header *ip );
int pkt_init(void);

int sbuf, rbuf;
int sbuflin, rbuflin;

int pkt_init(void)
{
  int pd_type;
  int class;
  int adrlin;
  int tbuf,i;
  int pkt_first = INT_FIRST;
  int pkt_last = INT_LAST;
  word wbuf;
  char *pktenv;
  char temp[strlen(pkt_line)];
  _go32_dpmi_registers reg2;

  if ((pktenv = getenv("TCP_PKTINT")) != (char *) 0) {
    pkt_interrupt = strtol (pktenv, NULL, 0);
    if (pkt_interrupt >= pkt_first && pkt_interrupt <= pkt_last)
      pkt_first = pkt_last = pkt_interrupt;
  }

  for (pkt_interrupt=pkt_first; pkt_interrupt<=pkt_last; ++pkt_interrupt)
  {
    _go32_dpmi_get_real_mode_interrupt_vector (pkt_interrupt, &seg_info);
    adrlin = (seg_info.rm_segment << 4) + seg_info.rm_offset;
    if (adrlin)
    {
      dosmemget(adrlin+3,strlen(pkt_line),temp);
      if ( ! memcmp( temp, pkt_line, strlen( pkt_line )))
	break;
    }
  }

  if ( pkt_interrupt > INT_LAST )
  {
    outs("NO PACKET DRIVER FOUND\r\n");
    return( 1 );
  }

  seg_info.size = SIZEPAR(sizeof(pktasm))       /* code  */
		+ SIZEPAR(REALBUF*(BUFSIZE+3))  /* recv bufor */
		+ SIZEPAR(SBUFSIZE)             /* send bufor */
		+ 1;                            /* type info */

  if (_go32_dpmi_allocate_dos_memory(&seg_info) != 0) {
    outs("Not enought Dos memory for packet driver bufor\r\n");
    return( 1 );
  }

  rbuf = SIZEPAR(sizeof(pktasm)) << 4;
  sbuf = rbuf + (SIZEPAR(REALBUF*(BUFSIZE+3)) << 4);
  tbuf = sbuf + (SIZEPAR(SBUFSIZE) << 4);

  adrlin = seg_info.rm_segment << 4;

  rbuflin = adrlin + rbuf;
  sbuflin = adrlin + sbuf;

  *((word *)(pktasm+0)) = REALBUF;
  *((word *)(pktasm+2)) = BUFSIZE;
  *((word *)(pktasm+4)) = rbuf;
  *((word *)(pktasm+6)) = rbuf+REALBUF;
  dosmemput(pktasm,sizeof(pktasm),adrlin);

  wbuf = 0;
  adrlin = rbuflin;
  for (i=0; i<REALBUF; i++)
    dosmemput(&wbuf,1,adrlin+i);

  adrlin = rbuflin + REALBUF;
  for (i=0; i<REALBUF; i++)
  {
    wbuf = rbuf+i;
    dosmemput(&wbuf,2,adrlin);
    adrlin += BUFSIZE+2;
  }

  adrlin = (seg_info.rm_segment << 4) + tbuf;
  dosmemput(&pkt_ip_type,2,adrlin);
  dosmemput(&pkt_arp_type,2,adrlin+2);

  /* lets find out about the driver */
  regs.x.ax = PD_DRIVER_INFO;
  _go32_dpmi_simulate_int(pkt_interrupt, &regs);

  /* handle old versions, assume a class and just keep trying */
  if (regs.x.flags & CARRY )
  {
    for ( class = 0; class < 2; ++class )
    {
      _pktdevclass = (class) ? PD_SLIP : PD_ETHER;
      for (pd_type = 1; pd_type < 128; ++pd_type )
      {
	regs.x.ax = PD_ACCESS | _pktdevclass;  /* ETH, SLIP */
	regs.x.bx = pd_type;            /* type */
	regs.x.dx = 0;                  /* if number */
	regs.x.cx = (_pktdevclass == PD_SLIP ) ? 0 : sizeof( pkt_ip_type);
	regs.x.ds = seg_info.rm_segment;
	regs.x.si = tbuf;
	regs.x.es = seg_info.rm_segment;
	regs.x.di = 8; /* begin of code */
	_go32_dpmi_simulate_int(pkt_interrupt, &regs);
	if ( ! (regs.x.flags & CARRY) ) break;
      }
      if (pd_type == 128 )
      {
	_go32_dpmi_free_dos_memory(&seg_info);
	outs("ERROR initializing packet driver\n\r");
	return( 1 );
      }
      /* we have found a working type, so kill it */
      regs.x.bx = regs.x.ax;    /* handle */
      regs.x.ax = PD_RELEASE;
      _go32_dpmi_simulate_int(pkt_interrupt, &regs);
    }
  } 
  else 
  {
    pd_type = regs.x.dx;
    switch ( _pktdevclass = (regs.x.cx >> 8))
    {
      case PD_ETHER : _pktipofs = 14;
      case PD_SLIP  : break;
      default       : outs("ERROR: only Ethernet or SLIP packet drivers allowed\n\r");
		      _go32_dpmi_free_dos_memory(&seg_info);
		      return( 1 );
    }
  }
  regs.x.ax = PD_ACCESS | _pktdevclass;
  regs.x.bx = 0xffff;                 /* any type */
  regs.x.dx = 0;                        /* if number */
  regs.x.cx = (_pktdevclass == PD_SLIP) ? 0 : sizeof( pkt_ip_type );
  regs.x.ds = seg_info.rm_segment;
  regs.x.si = tbuf;
  regs.x.es = seg_info.rm_segment;
  regs.x.di = 8; /* begin of code */
  memcpy( &reg2, &regs, sizeof( regs ));
  reg2.x.si = tbuf+2;

  _go32_dpmi_simulate_int(pkt_interrupt, &regs);
  if ( regs.x.flags & CARRY )
  {
    _go32_dpmi_free_dos_memory(&seg_info);
    outs("ERROR # 0x");
    outhex( regs.x.dx >> 8 );
    outs(" accessing packet driver\n\r" );
    return( 1 );
  }
  pkt_ip_handle = regs.x.ax;

  if (_pktdevclass != PD_SLIP)
  {
    _go32_dpmi_simulate_int(pkt_interrupt, &reg2);
    if ( reg2.x.flags & CARRY )
    {
      regs.x.ax = PD_RELEASE;
      regs.x.bx = pkt_ip_handle;
      _go32_dpmi_simulate_int(pkt_interrupt, &regs);
      _go32_dpmi_free_dos_memory(&seg_info);
      outs("ERROR # 0x");
      outhex( reg2.x.dx >> 8 );
      outs(" accessing packet driver\n\r" );
      return( 1 );
    }
    pkt_arp_handle = reg2.x.ax;
  }

  /* get ethernet address */
  regs.x.ax = PD_GET_ADDRESS;
  regs.x.bx = pkt_ip_handle;
  regs.x.es = seg_info.rm_segment;
  regs.x.di = tbuf+4;
  regs.x.cx = sizeof( eth_addr );
  _go32_dpmi_simulate_int(pkt_interrupt, &regs);
  if ( regs.x.flags & CARRY )
  {
    _go32_dpmi_free_dos_memory(&seg_info);
    outs("ERROR # reading ethernet address\n\r" );
    return( 1 );
  }
  adrlin = (seg_info.rm_segment << 4) + tbuf+4;
  dosmemget(adrlin,sizeof(eth_addr),&eth_addr);

  return( 0 );
}

void pkt_release()
{
  int error;

  if ( _pktdevclass != PD_SLIP )
  {
    regs.x.ax = PD_RELEASE;
    regs.x.bx = pkt_arp_handle;
    _go32_dpmi_simulate_int(pkt_interrupt, &regs);
    if (regs.x.flags & CARRY )
    {
      outs("ERROR releasing packet driver for ARP\n\r");
    }
  }

  regs.x.ax = PD_RELEASE;
  regs.x.bx = pkt_ip_handle;
  _go32_dpmi_simulate_int(pkt_interrupt, &regs);
  if (regs.x.flags & CARRY )
    outs("ERROR releasing packet driver for IP\n\r");

  _go32_dpmi_free_dos_memory(&seg_info);

  return;
}

int pkt_send( char *buffer, int length )
{
  int retries;

  if (length > SBUFSIZE)
    return ( 1 );
  dosmemput(buffer,length,sbuflin);
  retries = 5;
  while (retries--)
  {
    regs.x.ax = PD_SEND;
    regs.x.ds = seg_info.rm_segment;
    regs.x.si = sbuf;
    regs.x.cx = length;
    _go32_dpmi_simulate_int(pkt_interrupt, &regs);
    if ( regs.x.flags & CARRY )
      continue;
#ifdef TCPDEB /*debug*/
    debug("send",length,buffer);
#endif
    return( 0 );
  }
#ifdef TCPDEB /*debug*/
  {
    FILE *debug = fopen("debug.txt","a");
    fprintf(debug,"send err\n");
    fclose(debug);
  }
#endif
  return( 1 );
}

/* return a buffer to the pool */
void pkt_buf_wipe()
{
  int i;
  byte z;
  memset (pktbuf, 0, sizeof( byte ) * MAXBUFS * (BUFSIZE+ 2));
  z = 0;
  for (i=0; i<REALBUF; i++)
    dosmemput(&z,1,rbuflin+i);
}

void pkt_buf_release( char *ptr )
{
    *(ptr - (2 + _pktipofs)) = 0;
}

void *pkt_received()
{
  int i,k,n;
  word old,new;
  extern int active_frags;
  byte head[REALBUF];

  /* find number of new packed */
  dosmemget(rbuflin,REALBUF,head);
  n = 0;
  for (i=0; i<REALBUF; i++)
    if (head[i]) n++;
  
  /* copy new packet from real mode mem. */
  i=k=0;
  while (n>0)
  {
    /* find free buffor */
    while (k<MAXBUFS)
    {
      if (pktbuf[k][0]==0)
	break;
      k++;
    }
    /* no free buf. */
    if (k==MAXBUFS) break;

    /* find packet */
    while (i<REALBUF)
    {
      if (head[i])
	break;
      i++;
    }
    /* cannot find, should not happend */
    if (i==REALBUF) break;

    /* get data from real mode buf., free this buf. */

    dosmemget(rbuflin+REALBUF+i*(BUFSIZE+2)+2,BUFSIZE,&pktbuf[k][2]);
    pktbuf[k][0] = 1; /* has data */
    head[i]=0; /* no data */
    dosmemput(&head[i],1,rbuflin+i);
#ifdef TCPDEB /*debug*/
{
FILE *fd = fopen("debug.txt","a");
fprintf(fd,"r=%d, p=%d ",i,k);
fclose(fd);
debug("recv",64,&pktbuf[k][2]);
}
#endif
    k++;
    i++;
    n--;
  }

#ifdef FRAGSUPPORT
  if (active_frags) timeout_frags();
#endif /* FRAGSUPPORT */

  /* check for new ip packet */
  n = -1;
  old = 0xffff;
 
  for (i=0; i<MAXBUFS; i++)
  {
    in_Header *in;
    eth_Header *eth;

    /* no data, free pos. */
    if ( pktbuf[i][0] != 1 ) continue;

    /* check if ip & find ip header */
    if ( _pktdevclass == PD_ETHER )
    {
      eth = (eth_Header *) &(pktbuf[i][2]);
      if (eth->type != IP_TYPE) /* in intel form */
	in = NULL;
      else
        in = (in_Header *) &(pktbuf[i][2+sizeof(eth_Header)]);
    }
    else
      in = (in_Header *) &(pktbuf[i][2]);

    /* return any non ip packet */
    if (!in) return &(pktbuf[i][2]);

#ifdef FRAGSUPPORT
    if (!(in->frags & IP_DF) && (in->frags & (IP_NF | IP_OF)))
    {
      void *buf;

      buf = fragment (in);
      if (!buf)
	continue;
      else
	return(buf);
    }
#endif // FRAGSUPPORT

    /* find older ip packet */
    new = in->identification;
    
    if ( new <= old )
    {
      old = new;
      n = i;
    }
  }
  /* return oldest ip packet, if exist */
  return (n >= 0) ? &(pktbuf[n][2]) : NULL;
}

void * _pkt_eth_init()
{
    if ( pkt_init() ) {
	outs("Program halted\r\n");
	return NULL;
    }
    return( eth_addr );
}
