# sed script for additional DJGPP specific editing of ltmain.sh.

# Use func_lalib_p instead of func_lalib_unsafe_p.
/func_lalib_unsafe_p[ 	][^(]/ s/_unsafe//

# Adjust temp directory.
/{TMPDIR-\/tmp}/ s|{TMPDIR-/tmp}|{TMPDIR-${TMP-${TEMP-.}}}|

# Remove -lc reference from the "dependency_libs=" line in .la files.
# This is unnecessary when linking with static labraries and causes
# multiple symbol definitions that cannot be resolved when using DXE3 modules.
/^# Libraries that this one depends upon.$/,/^# Directory that this library needs to be installed in:$/ {
  /^# Directory that this library needs to be installed in:$/ {
    n
    a\
	  sed "/^dependency_libs=/ s|[ 	]\\{1,\\}-lc| |"  $output > fixed.sed && cp -vf fixed.sed $output
  }
}

# Replace (command) > /dev/null with `command > /dev/null`, since
# parenthesized commands always return zero status in the ported Bash,
# even if the named command doesn't exist.
/^func_extract_an_archive/,/^}$/ {
  /.*if[ 	](/ {
    s/(/`/
    s/)/`/
  }
}

# Make absolute paths shorter removing ".."
/^func_extract_archives/,/^}$/ {
/my_xdir=\$my_gentop\/\$my_xlib_u/ a\
      my_xabs=`echo "$my_xabs" | sed "s,/\\(\\./\\)\\+,/,;s,/\\([-_.A-Za-z0-9]\\+/\\.\\./\\)\\+,/,g"`\
\
#      if test "x\\${DJDIR}" != "x"; then\
#        # For platforms that have limitation in the path length:\
#        my_xdir=../_\
#      fi\

}

# Use shoter path.
/if test -n .*addlibs.* then$/,/fi$/ {
/func_append generated / i\
	if test "x\\${DJDIR}" != "x"; then\
	  # For platforms that have limitation in the path length:\
	  gentop=../_\
	fi
}
