@echo off
echo Configuring x264 0.164.3095_baee400 for DJGPP v2.5...

Rem WARNING WARNING WARNING: This file needs to have DOS CRLF end-of-line
Rem format, or else stock DOS/Windows shells will refuse to run it.

Rem The SmallEnv tests protect against fixed and too small size
Rem of the environment in stock DOS shell.

Rem Find out if NLS is wanted or not,
Rem if dependency-tracking is wanted or not,
Rem if caching is wanted or not
Rem and where the sources are.
Rem We always default to NLS support,
Rem no dependency tracking
Rem and to in place configuration.
set ARGS=
set ASM=enabled
if not "%ASM%" == "enabled" goto SmallEnv
set GPL=enabled
if not "%GPL%" == "enabled" goto SmallEnv
set STATIC=enabled
if not "%STATIC%" == "enabled" goto SmallEnv
set XSRC=.
if not "%XSRC%" == "." goto SmallEnv

Rem Loop over all arguments.
Rem Special arguments are: NLS, XSRC, CACHE, STATIC_LIBS, LIBICONV_PREFIX, LIBINTL_PREFIX and DEPS.
Rem All other arguments are stored into ARGS.
:ArgLoop
if "%1" == "asm" goto NextArgument
if "%1" == "ASM" goto NextArgument
if "%1" == "no-asm" goto NoASM
if "%1" == "no-ASM" goto NoASM
if "%1" == "NO-ASM" goto NoASM
goto GplOption
:NoASM
if "%1" == "no-asm" set ASM=disabled
if "%1" == "no-ASM" set ASM=disabled
if "%1" == "NO-ASM" set ASM=disabled
if not "%ASM%" == "disabled" goto SmallEnv
goto NextArgument
:GplOption
if "%1" == "gpl" goto NextArgument
if "%1" == "GPL" goto NextArgument
if "%1" == "no-gpl" goto NoGPL
if "%1" == "no-GPL" goto NoGPL
if "%1" == "NO-GPL" goto NoGPL
goto StaticOption
:NoGPL
if "%1" == "no-gpl" set GPL=disabled
if "%1" == "no-GPL" set GPL=disabled
if "%1" == "NO-GPL" set GPL=disabled
if not "%GPL%" == "disabled" goto SmallEnv
goto NextArgument
:StaticOption
if "%1" == "static" goto NextArgument
if "%1" == "STATIC" goto NextArgument
if "%1" == "no-static" goto NoSTATIC
if "%1" == "no-STATIC" goto NoSTATIC
if "%1" == "NO-STATIC" goto NoSTATIC
goto SrcDirOption
:NoSTATIC
if "%1" == "no-static" set STATIC=disabled
if "%1" == "no-STATIC" set STATIC=disabled
if "%1" == "NO-STATIC" set STATIC=disabled
if not "%STATIC%" == "disabled" goto SmallEnv
goto NextArgument
:SrcDirOption
echo %1 | grep -q "/"
if errorlevel 1 goto CollectArgument
set XSRC=%1
if not "%XSRC%" == "%1" goto SmallEnv
goto NextArgument
:CollectArgument
set _ARGS=#%ARGS%#%1#
if not "%_ARGS%" == "#%ARGS%#%1#" goto SmallEnv
echo %_ARGS% | grep -q "###"
if errorlevel 1 set ARGS=%ARGS% %1
set _ARGS=
:NextArgument
shift
if not "%1" == "" goto ArgLoop

Rem Create an arguments file for the configure script.
echo --prefix=/dev/env/DJDIR > args
if "%ASM%" == "enabled"                  echo --enable-asm >> args
if "%ASM%" == "disabled"                 echo --disable-asm >> args
if "%GPL%" == "enabled"                  echo --enable-gpl >> args
if "%GPL%" == "disabled"                 echo --disable-gpl >> args
if "%STATIC%" == "enabled"               echo --enable-static >> args
if "%STATIC%" == "disabled"              echo --disable-static >> args
if not "%ARGS%" == ""                    echo %ARGS% >> args

set ARGS=
set ASM=
set GPL=
set STATIC=

if "%XSRC%" == "." goto InPlace


:InPlace
Rem A dummy jump point.


Rem Set SHELL to a sane default or some configure tests stop working
Rem if the package is configured across partitions.
if not "%SHELL%" == "" goto HomeName
set SHELL=/bin/sh
if not "%SHELL%" == "/bin/sh" goto SmallEnv
echo No SHELL found in the environment, using default value

:HomeName
Rem Set HOME to a sane default so configure stops complaining.
if not "%HOME%" == "" goto HostName
set HOME=%XSRC%/djgpp
if not "%HOME%" == "%XSRC%/djgpp" goto SmallEnv
echo No HOME found in the environment, using default value

:HostName
Rem Set HOSTNAME so it shows in config.status
if not "%HOSTNAME%" == "" goto hostdone
if "%windir%" == "" goto msdos
set OS=MS-Windows
if not "%OS%" == "MS-Windows" goto SmallEnv
goto haveos
:msdos
set OS=MS-DOS
if not "%OS%" == "MS-DOS" goto SmallEnv
:haveos
if not "%USERNAME%" == "" goto haveuname
if not "%USER%" == "" goto haveuser
echo No USERNAME and no USER found in the environment, using default values
set HOSTNAME=Unknown PC
if not "%HOSTNAME%" == "Unknown PC" goto SmallEnv
goto userdone
:haveuser
set HOSTNAME=%USER%'s PC
if not "%HOSTNAME%" == "%USER%'s PC" goto SmallEnv
goto userdone
:haveuname
set HOSTNAME=%USERNAME%'s PC
if not "%HOSTNAME%" == "%USERNAME%'s PC" goto SmallEnv
:userdone
set _HOSTNAME=%HOSTNAME%, %OS%
if not "%_HOSTNAME%" == "%HOSTNAME%, %OS%" goto SmallEnv
set HOSTNAME=%_HOSTNAME%
:hostdone
set _HOSTNAME=
set OS=

:ConfigurePackage
echo Running the ./configure script...
sh %XSRC%/configure @args
if errorlevel 1 goto RunConfigStatus
rm args
echo Done.
goto EditFiles
:RunConfigStatus
test -f ./config.status
if errorlevel 1 goto CfgError
echo Running the ./config.status script (manually)...
redir -e /dev/null sh ./config.status
if errorlevel 1 goto CfgError
rm args
echo Done.

:EditFiles

Rem Create po/LINGUAS file or the build fails.
update %XSRC%/po/LINGUAS ./po/LINGUAS
goto End

:CfgError
echo ./configure script exited abnormally!
goto End

:SmallEnv
echo Your environment size is too small.  Enlarge it and run me again.
echo Configuration NOT done!

:End
if "%SHELL%" == "/bin/sh" set SHELL=
if "%HOME%" == "%XSRC%/djgpp" set HOME=
set ARGS=
set ASM=
set GPL=
set STATIC=
set XSRC=
