This is Info file ./termcap.info, produced by Makeinfo-1.55 from the
input file ./termcap.texi.

   This file documents the termcap library of the GNU system.

   Copyright (C) 1988 Free Software Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided that
the entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be stated in a
translation approved by the Foundation.


File: termcap.info,  Node: Insdel Char,  Next: Standout,  Prev: Insdel Line,  Up: Capabilities

Insert/Delete Character
=======================

   "Inserting a character" means creating a blank space in the middle
of a line, and pushing the rest of the line rightward.  The character
in the rightmost column is lost.

   "Deleting a character" means causing the character to disappear from
the screen, closing up the gap by moving the rest of the line leftward.
A blank space appears in the rightmost column.

   Insertion and deletion of characters is useful in programs that
maintain an updating display some parts of which may get longer or
shorter.  It is also useful in editors for redisplaying the results of
editing within a line.

   Many terminals provide commands to insert or delete a single
character at the cursor position.  Some provide the ability to insert
or delete several characters with one command, using the number of
characters to insert or delete as a parameter.

   Many terminals provide an insert mode in which outputting a graphic
character has the added effect of inserting a position for that
character.  A special command string is used to enter insert mode and
another is used to exit it.  The reason for designing a terminal with
an insert mode rather than an insert command is that inserting
character positions is usually followed by writing characters into
them.  With insert mode, this is as fast as simply writing the
characters, except for the fixed overhead of entering and leaving
insert mode.  However, when the line speed is great enough, padding may
be required for the graphic characters output in insert mode.

   Some terminals require you to enter insert mode and then output a
special command for each position to be inserted.  Or they may require
special commands to be output before or after each graphic character to
be inserted.

   Deletion of characters is usually accomplished by a straightforward
command to delete one or several positions; but on some terminals, it
is necessary to enter a special delete mode before using the delete
command, and leave delete mode afterward.  Sometimes delete mode and
insert mode are the same mode.

   Some terminals make a distinction between character positions in
which a space character has been output and positions which have been
cleared.  On these terminals, the effect of insert or delete character
runs to the first cleared position rather than to the end of the line.
In fact, the effect may run to more than one line if there is no
cleared position to stop the shift on the first line.  These terminals
are identified by the `in' flag capability.

   On terminals with the `in' flag, the technique of skipping over
characters that you know were cleared, and then outputting text later
on in the same line, causes later insert and delete character
operations on that line to do nonstandard things.  A program that has
any chance of doing this must check for the `in' flag and must be
careful to write explicit space characters into the intermediate
columns when `in' is present.

   A plethora of terminal capabilities are needed to describe all of
this complexity.  Here is a list of them all.  Following the list, we
present an algorithm for programs to use to take proper account of all
of these capabilities.

`im'
     String of commands to enter insert mode.

     If the terminal has no special insert mode, but it can insert
     characters with a special command, `im' should be defined with a
     null value, because the `vi' editor assumes that insertion of a
     character is impossible if `im' is not provided.

     New programs should not act like `vi'.  They should pay attention
     to `im' only if it is defined.

`ei'
     String of commands to leave insert mode.  This capability must be
     present if `im' is.

     On a few old terminals the same string is used to enter and exit
     insert mode.  This string turns insert mode on if it was off, and
     off it it was on.  You can tell these terminals because the `ei'
     string equals the `im' string.  If you want to support these
     terminals, you must always remember accurately whether insert mode
     is in effect.  However, these terminals are obsolete, and it is
     reasonable to refuse to support them.  On all modern terminals, you
     can safely output `ei' at any time to ensure that insert mode is
     turned off.

`ic'
     String of commands to insert one character position at the cursor.
     The cursor does not move.

     If outputting a graphic character while in insert mode is
     sufficient to insert the character, then the `ic' capability
     should be defined with a null value.

     If your terminal offers a choice of ways to insert--either use
     insert mode or use a special command--then define `im' and do not
     define `ic', since this gives the most efficient operation when
     several characters are to be inserted.  *Do not* define both
     strings, for that means that *both* must be used each time
     insertion is done.

`ip'
     String of commands to output following an inserted graphic
     character in insert mode.  Often it is used just for a padding
     spec, when padding is needed after an inserted character (*note
     Padding::.).

`IC'
     String of commands to insert N character positions at and after
     the cursor.  It has the same effect as repeating the `ic' string
     and a space, N times.

     If `IC' is provided, application programs may use it without first
     entering insert mode.

`mi'
     Flag whose presence means it is safe to move the cursor while in
     insert mode and assume the terminal remains in insert mode.

`in'
     Flag whose presence means that the terminal distinguishes between
     character positions in which space characters have been output and
     positions which have been cleared.

   An application program can assume that the terminal can do character
insertion if *any one of* the capabilities `IC', `im', `ic' or `ip' is
provided.

   To insert N blank character positions, move the cursor to the place
to insert them and follow this algorithm:

  1. If an `IC' string is provided, output it with parameter N and you
     are finished.  Otherwise (or if you don't want to bother to look
     for an `IC' string) follow the remaining steps.

  2. Output the `im' string, if there is one, unless the terminal is
     already in insert mode.

  3. Repeat steps 4 through 6, N times.

  4. Output the `ic' string if any.

  5. Output a space.

  6. Output the `ip' string if any.

  7. Output the `ei' string, eventually, to exit insert mode.  There is
     no need to do this right away.  If the `mi' flag is present, you
     can move the cursor and the cursor will remain in insert mode;
     then you can do more insertion elsewhere without reentering insert
     mode.

   To insert N graphic characters, position the cursor and follow this
algorithm:

  1. If an `IC' string is provided, output it with parameter N, then
     output the graphic characters, and you are finished.  Otherwise
     (or if you don't want to bother to look for an `IC' string) follow
     the remaining steps.

  2. Output the `im' string, if there is one, unless the terminal is
     already in insert mode.

  3. For each character to be output, repeat steps 4 through 6.

  4. Output the `ic' string if any.

  5. Output the next graphic character.

  6. Output the `ip' string if any.

  7. Output the `ei' string, eventually, to exit insert mode.  There is
     no need to do this right away.  If the `mi' flag is present, you
     can move the cursor and the cursor will remain in insert mode;
     then you can do more insertion elsewhere without reentering insert
     mode.

   Note that this is not the same as the original Unix termcap
specifications in one respect: it assumes that the `IC' string can be
used without entering insert mode.  This is true as far as I know, and
it allows you be able to avoid entering and leaving insert mode, and
also to be able to avoid the inserted-character padding after the
characters that go into the inserted positions.

   Deletion of characters is less complicated; deleting one column is
done by outputting the `dc' string.  However, there may be a delete
mode that must be entered with `dm' in order to make `dc' work.

`dc'
     String of commands to delete one character position at the cursor.
     If `dc' is not present, the terminal cannot delete characters.

`DC'
     String of commands to delete N characters starting at the cursor.
     It has the same effect as repeating the `dc' string N times.  Any
     terminal description that has `DC' also has `dc'.

`dm'
     String of commands to enter delete mode.  If not present, there is
     no delete mode, and `dc' can be used at any time (assuming there is
     a `dc').

`ed'
     String of commands to exit delete mode.  This must be present if
     `dm' is.

   To delete N character positions, position the cursor and follow these
steps:

  1. If the `DC' string is present, output it with parameter N and you
     are finished.  Otherwise, follow the remaining steps.

  2. Output the `dm' string, unless you know the terminal is already in
     delete mode.

  3. Output the `dc' string N times.

  4. Output the `ed' string eventually.  If the flag capability `mi' is
     present, you can move the cursor and do more deletion without
     leaving and reentering delete mode.

   As with the `IC' string, we have departed from the original termcap
specifications by assuming that `DC' works without entering delete mode
even though `dc' would not.

   If the `dm' and `im' capabilities are both present and have the same
value, it means that the terminal has one mode for both insertion and
deletion.  It is useful for a program to know this, because then it can
do insertions after deletions, or vice versa, without leaving
insert/delete mode and reentering it.


File: termcap.info,  Node: Standout,  Next: Underlining,  Prev: Insdel Char,  Up: Capabilities

Standout and Appearance Modes
=============================

   "Appearance modes" are modifications to the ways characters are
displayed.  Typical appearance modes include reverse video, dim, bright,
blinking, underlined, invisible, and alternate character set.  Each
kind of terminal supports various among these, or perhaps none.

   For each type of terminal, one appearance mode or combination of
them that looks good for highlighted text is chosen as the "standout
mode".  The capabilities `so' and `se' say how to enter and leave
standout mode.  Programs that use appearance modes only to highlight
some text generally use the standout mode so that they can work on as
many terminals as possible.  Use of specific appearance modes other
than "underlined" and "alternate character set" is rare.

   Terminals that implement appearance modes fall into two general
classes as to how they do it.

   In some terminals, the presence or absence of any appearance mode is
recorded separately for each character position.  In these terminals,
each graphic character written is given the appearance modes current at
the time it is written, and keeps those modes until it is erased or
overwritten.  There are special commands to turn the appearance modes
on or off for characters to be written in the future.

   In other terminals, the change of appearance modes is represented by
a marker that belongs to a certain screen position but affects all
following screen positions until the next marker.  These markers are
traditionally called "magic cookies".

   The same capabilities (`so', `se', `mb' and so on) for turning
appearance modes on and off are used for both magic-cookie terminals
and per-character terminals.  On magic cookie terminals, these give the
commands to write the magic cookies.  On per-character terminals, they
change the current modes that affect future output and erasure.  Some
simple applications can use these commands without knowing whether or
not they work by means of cookies.

   However, a program that maintains and updates a display needs to know
whether the terminal uses magic cookies, and exactly what their effect
is.  This information comes from the `sg' capability.

   The `sg' capability is a numeric capability whose presence indicates
that the terminal uses magic cookies for appearance modes.  Its value is
the number of character positions that a magic cookie occupies.  Usually
the cookie occupies one or more character positions on the screen, and
these character positions are displayed as blank, but in some terminals
the cookie has zero width.

   The `sg' capability describes both the magic cookie to turn standout
on and the cookie to turn it off.  This makes the assumption that both
kinds of cookie have the same width on the screen.  If that is not true,
the narrower cookie must be "widened" with spaces until it has the same
width as the other.

   On some magic cookie terminals, each line always starts with normal
display; in other words, the scope of a magic cookie never extends over
more than one line.  But on other terminals, one magic cookie affects
all the lines below it unless explicitly canceled.  Termcap does not
define any way to distinguish these two ways magic cookies can work.
To be safe, it is best to put a cookie at the beginning of each line.

   On some per-character terminals, standout mode or other appearance
modes may be canceled by moving the cursor.  On others, moving the
cursor has no effect on the state of the appearance modes.  The latter
class of terminals are given the flag capability `ms' ("can move in
standout").  All programs that might have occasion to move the cursor
while appearance modes are turned on must check for this flag; if it is
not present, they should reset appearance modes to normal before doing
cursor motion.

   A program that has turned on only standout mode should use `se' to
reset the standout mode to normal.  A program that has turned on only
alternate character set mode should use `ae' to return it to normal.
If it is possible that any other appearance modes are turned on, use the
`me' capability to return them to normal.

   Note that the commands to turn on one appearance mode, including `so'
and `mb' ... `mr', if used while some other appearance modes are turned
on, may combine the two modes on some terminals but may turn off the
mode previously enabled on other terminals.  This is because some
terminals do not have a command to set or clear one appearance mode
without changing the others.  Programs should not attempt to use
appearance modes in combination except with `sa', and when switching
from one single mode to another should always turn off the previously
enabled mode and then turn on the new desired mode.

   On some old terminals, the `so' and `se' commands may be the same
command, which has the effect of turning standout on if it is off, or
off it is on.  It is therefore risky for a program to output extra `se'
commands for good measure.  Fortunately, all these terminals are
obsolete.

   Programs that update displays in which standout-text may be replaced
with non-standout text must check for the `xs' flag.  In a per-character
terminal, this flag says that the only way to remove standout once
written is to clear that portion of the line with the `ce' string or
something even more powerful (*note Clearing::.); just writing new
characters at those screen positions will not change the modes in
effect there.  In a magic cookie terminal, `xs' says that the only way
to remove a cookie is to clear a portion of the line that includes the
cookie; writing a different cookie at the same position does not work.

   Such programs must also check for the `xt' flag, which means that the
terminal is a Teleray 1061.  On this terminal it is impossible to
position the cursor at the front of a magic cookie, so the only two
ways to remove a cookie are (1) to delete the line it is on or (2) to
position the cursor at least one character before it (possibly on a
previous line) and output the `se' string, which on these terminals
finds and removes the next `so' magic cookie on the screen.  (It may
also be possible to remove a cookie which is not at the beginning of a
line by clearing that line.)  The `xt' capability also has implications
for the use of tab characters, but in that regard it is obsolete (*Note
Cursor Motion::).

`so'
     String of commands to enter standout mode.

`se'
     String of commands to leave standout mode.

`sg'
     Numeric capability, the width on the screen of the magic cookie.
     This capability is absent in terminals that record appearance modes
     character by character.

`ms'
     Flag whose presence means that it is safe to move the cursor while
     the appearance modes are not in the normal state.  If this flag is
     absent, programs should always reset the appearance modes to
     normal before moving the cursor.

`xs'
     Flag whose presence means that the only way to reset appearance
     modes already on the screen is to clear to end of line.  On a
     per-character terminal, you must clear the area where the modes
     are set.  On a magic cookie terminal, you must clear an area
     containing the cookie.  See the discussion above.

`xt'
     Flag whose presence means that the cursor cannot be positioned
     right in front of a magic cookie, and that `se' is a command to
     delete the next magic cookie following the cursor.  See discussion
     above.

`mb'
     String of commands to enter blinking mode.

`md'
     String of commands to enter double-bright mode.

`mh'
     String of commands to enter half-bright mode.

`mk'
     String of commands to enter invisible mode.

`mp'
     String of commands to enter protected mode.

`mr'
     String of commands to enter reverse-video mode.

`me'
     String of commands to turn off all appearance modes, including
     standout mode and underline mode.  On some terminals it also turns
     off alternate character set mode; on others, it may not.  This
     capability must be present if any of `mb' ... `mr' is present.

`as'
     String of commands to turn on alternate character set mode.  This
     mode assigns some or all graphic characters an alternate picture
     on the screen.  There is no standard as to what the alternate
     pictures look like.

`ae'
     String of commands to turn off alternate character set mode.

`sa'
     String of commands to turn on an arbitrary combination of
     appearance modes.  It accepts 9 parameters, each of which controls
     a particular kind of appearance mode.  A parameter should be 1 to
     turn its appearance mode on, or zero to turn that mode off.  Most
     terminals do not support the `sa' capability, even among those
     that do have various appearance modes.

     The nine parameters are, in order, STANDOUT, UNDERLINE, REVERSE,
     BLINK, HALF-BRIGHT, DOUBLE-BRIGHT, BLANK, PROTECT, ALT CHAR SET.


File: termcap.info,  Node: Underlining,  Next: Cursor Visibility,  Prev: Standout,  Up: Capabilities

Underlining
===========

   Underlining on most terminals is a kind of appearance mode, much like
standout mode.  Therefore, it may be implemented using magic cookies or
as a flag in the terminal whose current state affects each character
that is output.  *Note Standout::, for a full explanation.

   The `ug' capability is a numeric capability whose presence indicates
that the terminal uses magic cookies for underlining.  Its value is the
number of character positions that a magic cookie for underlining
occupies; it is used for underlining just as `sg' is used for standout.
Aside from the simplest applications, it is impossible to use
underlining correctly without paying attention to the value of `ug'.

`us'
     String of commands to turn on underline mode or to output a magic
     cookie to start underlining.

`ue'
     String of commands to turn off underline mode or to output a magic
     cookie to stop underlining.

`ug'
     Width of magic cookie that represents a change of underline mode;
     or missing, if the terminal does not use a magic cookie for this.

`ms'
     Flag whose presence means that it is safe to move the cursor while
     the appearance modes are not in the normal state.  Underlining is
     an appearance mode.  If this flag is absent, programs should
     always turn off underlining before moving the cursor.

   There are two other, older ways of doing underlining: there can be a
command to underline a single character, or the output of `_', the
ASCII underscore character, as an overstrike could cause a character to
be underlined.  New programs need not bother to handle these
capabilities unless the author cares strongly about the obscure
terminals which support them.  However, terminal descriptions should
provide these capabilities when appropriate.

`uc'
     String of commands to underline the character under the cursor, and
     move the cursor right.

`ul'
     Flag whose presence means that the terminal can underline by
     overstriking an underscore character (`_'); some terminals can do
     this even though they do not support overstriking in general.  An
     implication of this flag is that when outputting new text to
     overwrite old text, underscore characters must be treated
     specially lest they underline the old text instead.


File: termcap.info,  Node: Cursor Visibility,  Next: Bell,  Prev: Underlining,  Up: Capabilities

Cursor Visibility
=================

   Some terminals have the ability to make the cursor invisible, or to
enhance it.  Enhancing the cursor is often done by programs that plan
to use the cursor to indicate to the user a position of interest that
may be anywhere on the screen--for example, the Emacs editor enhances
the cursor on entry.  Such programs should always restore the cursor to
normal on exit.

`vs'
     String of commands to enhance the cursor.

`vi'
     String of commands to make the cursor invisible.

`ve'
     String of commands to return the cursor to normal.

   If you define either `vs' or `vi', you must also define `ve'.


File: termcap.info,  Node: Bell,  Next: Keypad,  Prev: Cursor Visibility,  Up: Capabilities

Bell
====

   Here we describe commands to make the terminal ask for the user to
pay attention to it.

`bl'
     String of commands to cause the terminal to make an audible sound.
     If this capability is absent, the terminal has no way to make a
     suitable sound.

`vb'
     String of commands to cause the screen to flash to attract
     attention ("visible bell").  If this capability is absent, the
     terminal has no way to do such a thing.


File: termcap.info,  Node: Keypad,  Next: Meta Key,  Prev: Bell,  Up: Capabilities

Keypad and Function Keys
========================

   Many terminals have arrow and function keys that transmit specific
character sequences to the computer.  Since the precise sequences used
depend on the terminal, termcap defines capabilities used to say what
the sequences are.  Unlike most termcap string-valued capabilities,
these are not strings of commands to be sent to the terminal, rather
strings that are received from the terminal.

   Programs that expect to use keypad keys should check, initially, for
a `ks' capability and send it, to make the keypad actually transmit.
Such programs should also send the `ke' string when exiting.

`ks'
     String of commands to make the keypad keys transmit.  If this
     capability is not provided, but the others in this section are,
     programs may assume that the keypad keys always transmit.

`ke'
     String of commands to make the keypad keys work locally.  This
     capability is provided only if `ks' is.

`kl'
     String of input characters sent by typing the left-arrow key.  If
     this capability is missing, you cannot expect the terminal to have
     a left-arrow key that transmits anything to the computer.

`kr'
     String of input characters sent by typing the right-arrow key.

`ku'
     String of input characters sent by typing the up-arrow key.

`kd'
     String of input characters sent by typing the down-arrow key.

`kh'
     String of input characters sent by typing the "home-position" key.

`K1' ... `K5'
     Strings of input characters sent by the five other keys in a 3-by-3
     array that includes the arrow keys, if the keyboard has such a
     3-by-3 array.  Note that one of these keys may be the
     "home-position" key, in which case one of these capabilities will
     have the same value as the `kh' key.

`k0'
     String of input characters sent by function key 10 (or 0, if the
     terminal has one labeled 0).

`k1' ... `k9'
     Strings of input characters sent by function keys 1 through 9,
     provided for those function keys that exist.

`kn'
     Number: the number of numbered function keys, if there are more
     than 10.

`l0' ... `l9'
     Strings which are the labels appearing on the keyboard on the keys
     described by the capabilities `k0' ... `l9'.  These capabilities
     should be left undefined if the labels are `f0' or `f10' and `f1'
     ... `f9'.

`kH'
     String of input characters sent by the "home down" key, if there is
     one.

`kb'
     String of input characters sent by the "backspace" key, if there is
     one.

`ka'
     String of input characters sent by the "clear all tabs" key, if
     there is one.

`kt'
     String of input characters sent by the "clear tab stop this column"
     key, if there is one.

`kC'
     String of input characters sent by the "clear screen" key, if
     there is one.

`kD'
     String of input characters sent by the "delete character" key, if
     there is one.

`kL'
     String of input characters sent by the "delete line" key, if there
     is one.

`kM'
     String of input characters sent by the "exit insert mode" key, if
     there is one.

`kE'
     String of input characters sent by the "clear to end of line" key,
     if there is one.

`kS'
     String of input characters sent by the "clear to end of screen"
     key, if there is one.

`kI'
     String of input characters sent by the "insert character" or "enter
     insert mode" key, if there is one.

`kA'
     String of input characters sent by the "insert line" key, if there
     is one.

`kN'
     String of input characters sent by the "next page" key, if there is
     one.

`kP'
     String of input characters sent by the "previous page" key, if
     there is one.

`kF'
     String of input characters sent by the "scroll forward" key, if
     there is one.

`kR'
     String of input characters sent by the "scroll reverse" key, if
     there is one.

`kT'
     String of input characters sent by the "set tab stop in this
     column" key, if there is one.

`ko'
     String listing the other function keys the terminal has.  This is a
     very obsolete way of describing the same information found in the
     `kH' ... `kT' keys.  The string contains a list of two-character
     termcap capability names, separated by commas.  The meaning is
     that for each capability name listed, the terminal has a key which
     sends the string which is the value of that capability.  For
     example, the value `:ko=cl,ll,sf,sr:' says that the terminal has
     four function keys which mean "clear screen", "home down", "scroll
     forward" and "scroll reverse".


File: termcap.info,  Node: Meta Key,  Next: Initialization,  Prev: Keypad,  Up: Capabilities

Meta Key
========

   A Meta key is a key on the keyboard that modifies each character you
type by controlling the 0200 bit.  This bit is on if and only if the
Meta key is held down when the character is typed.  Characters typed
using the Meta key are called Meta characters.  Emacs uses Meta
characters as editing commands.

`km'
     Flag whose presence means that the terminal has a Meta key.

`mm'
     String of commands to enable the functioning of the Meta key.

`mo'
     String of commands to disable the functioning of the Meta key.

   If the terminal has `km' but does not have `mm' and `mo', it means
that the Meta key always functions.  If it has `mm' and `mo', it means
that the Meta key can be turned on or off.  Send the `mm' string to
turn it on, and the `mo' string to turn it off.  I do not know why one
would ever not want it to be on.


File: termcap.info,  Node: Initialization,  Next: Pad Specs,  Prev: Meta Key,  Up: Capabilities

Initialization
==============

`ti'
     String of commands to put the terminal into whatever special modes
     are needed or appropriate for programs that move the cursor
     nonsequentially around the screen.  Programs that use termcap to do
     full-screen display should output this string when they start up.

`te'
     String of commands to undo what is done by the `ti' string.
     Programs that output the `ti' string on entry should output this
     string when they exit.

`is'
     String of commands to initialize the terminal for each login
     session.

`if'
     String which is the name of a file containing the string of
     commands to initialize the terminal for each session of use.
     Normally `is' and `if' are not both used.

`i1'
`i3'
     Two more strings of commands to initialize the terminal for each
     login session.  The `i1' string (if defined) is output before `is'
     or `if', and the `i3' string (if defined) is output after.

     The reason for having three separate initialization strings is to
     make it easier to define a group of related terminal types with
     slightly different initializations.  Define two or three of the
     strings in the basic type; then the other types can override one
     or two of the strings.

`rs'
     String of commands to reset the terminal from any strange mode it
     may be in.  Normally this includes the `is' string (or other
     commands with the same effects) and more.  What would go in the
     `rs' string but not in the `is' string are annoying or slow
     commands to bring the terminal back from strange modes that nobody
     would normally use.

`it'
     Numeric value, the initial spacing between hardware tab stop
     columns when the terminal is powered up.  Programs to initialize
     the terminal can use this to decide whether there is a need to set
     the tab stops.  If the initial width is 8, well and good; if it is
     not 8, then the tab stops should be set; if they cannot be set,
     the kernel is told to convert tabs to spaces, and other programs
     will observe this and do likewise.

`ct'
     String of commands to clear all tab stops.

`st'
     String of commands to set tab stop at current cursor column on all
     lines.

`NF'
     Flag whose presence means that the terminal does not support
     XON/XOFF flow control.  Programs should not send XON (`C-q') or
     XOFF (`C-s') characters to the terminal.


File: termcap.info,  Node: Pad Specs,  Next: Status Line,  Prev: Initialization,  Up: Capabilities

Padding Capabilities
====================

   There are two terminal capabilities that exist just to explain the
proper way to obey the padding specifications in all the command string
capabilities.  One, `pc', must be obeyed by all termcap-using programs.

`pb'
     Numeric value, the lowest baud rate at which padding is actually
     needed.  Programs may check this and refrain from doing any
     padding at lower speeds.

`pc'
     String of commands for padding.  The first character of this
     string is to be used as the pad character, instead of using null
     characters for padding.  If `pc' is not provided, use null
     characters.  Every program that uses termcap must look up this
     capability and use it to set the variable `PC' that is used by
     `tputs'.  *Note Padding::.

   Some termcap capabilities exist just to specify the amount of
padding that the kernel should give to cursor motion commands used in
ordinary sequential output.

`dC'
     Numeric value, the number of msec of padding needed for the
     carriage-return character.

`dN'
     Numeric value, the number of msec of padding needed for the newline
     (linefeed) character.

`dB'
     Numeric value, the number of msec of padding needed for the
     backspace character.

`dF'
     Numeric value, the number of msec of padding needed for the
     formfeed character.

`dT'
     Numeric value, the number of msec of padding needed for the tab
     character.

   In some systems, the kernel uses the above capabilities; in other
systems, the kernel uses the paddings specified in the string
capabilities `cr', `sf', `le', `ff' and `ta'.  Descriptions of
terminals which require such padding should contain the `dC' ...  `dT'
capabilities and also specify the appropriate padding in the
corresponding string capabilities.  Since no modern terminals require
padding for ordinary sequential output, you probably won't need to do
either of these things.


File: termcap.info,  Node: Status Line,  Next: Half-Line,  Prev: Pad Specs,  Up: Capabilities

Status Line
===========

   A "status line" is a line on the terminal that is not used for
ordinary display output but instead used for a special message.  The
intended use is for a continuously updated description of what the
user's program is doing, and that is where the name "status line" comes
from, but in fact it could be used for anything.  The distinguishing
characteristic of a status line is that ordinary output to the terminal
does not affect it; it changes only if the special status line commands
of this section are used.

`hs'
     Flag whose presence means that the terminal has a status line.  If
     a terminal description specifies that there is a status line, it
     must provide the `ts' and `fs' capabilities.

`ts'
     String of commands to move the terminal cursor into the status
     line.  Usually these commands must specifically record the old
     cursor position for the sake of the `fs' string.

`fs'
     String of commands to move the cursor back from the status line to
     its previous position (outside the status line).

`es'
     Flag whose presence means that other display commands work while
     writing the status line.  In other words, one can clear parts of
     it, insert or delete characters, move the cursor within it using
     `ch' if there is a `ch' capability, enter and leave standout mode,
     and so on.

`ds'
     String of commands to disable the display of the status line.  This
     may be absent, if there is no way to disable the status line
     display.

`ws'
     Numeric value, the width of the status line.  If this capability is
     absent in a terminal that has a status line, it means the status
     line is the same width as the other lines.

     Note that the value of `ws' is sometimes as small as 8.


File: termcap.info,  Node: Half-Line,  Next: Printer,  Prev: Status Line,  Up: Capabilities

Half-Line Motion
================

   Some terminals have commands for moving the cursor vertically by
half-lines, useful for outputting subscripts and superscripts.  Mostly
it is hardcopy terminals that have such features.

`hu'
     String of commands to move the cursor up half a line.  If the
     terminal is a display, it is your responsibility to avoid moving
     up past the top line; however, most likely the terminal that
     supports this is a hardcopy terminal and there is nothing to be
     concerned about.

`hd'
     String of commands to move the cursor down half a line.  If the
     terminal is a display, it is your responsibility to avoid moving
     down past the bottom line, etc.


File: termcap.info,  Node: Printer,  Prev: Half-Line,  Up: Capabilities

Controlling Printers Attached to Terminals
==========================================

   Some terminals have attached hardcopy printer ports.  They may be
able to copy the screen contents to the printer; they may also be able
to redirect output to the printer.  Termcap does not have anything to
tell the program whether the redirected output appears also on the
screen; it does on some terminals but not all.

`ps'
     String of commands to cause the contents of the screen to be
     printed.  If it is absent, the screen contents cannot be printed.

`po'
     String of commands to redirect further output to the printer.

`pf'
     String of commands to terminate redirection of output to the
     printer.  This capability must be present in the description if
     `po' is.

`pO'
     String of commands to redirect output to the printer for next N
     characters of output, regardless of what they are.  Redirection
     will end automatically after N characters of further output.  Until
     then, nothing that is output can end redirection, not even the
     `pf' string if there is one.  The number N should not be more than
     255.

     One use of this capability is to send non-text byte sequences
     (such as bit-maps) to the printer.

   Most terminals with printers do not support all of `ps', `po' and
`pO'; any one or two of them may be supported.  To make a program that
can send output to all kinds of printers, it is necessary to check for
all three of these capabilities, choose the most convenient of the ones
that are provided, and use it in its own appropriate fashion.


File: termcap.info,  Node: Summary,  Next: Var Index,  Prev: Capabilities,  Up: Top

Summary of Capability Names
***************************

   Here are all the terminal capability names in alphabetical order
with a brief description of each.  For cross references to their
definitions, see the index of capability names (*note Cap Index::.).

`ae'
     String to turn off alternate character set mode.

`al'
     String to insert a blank line before the cursor.

`AL'
     String to insert N blank lines before the cursor.

`am'
     Flag: output to last column wraps cursor to next line.

`as'
     String to turn on alternate character set mode.like.

`bc'
     Very obsolete alternative name for the `le' capability.

`bl'
     String to sound the bell.

`bs'
     Obsolete flag: ASCII backspace may be used for leftward motion.

`bt'
     String to move the cursor left to the previous hardware tab stop
     column.

`bw'
     Flag: `le' at left margin wraps to end of previous line.

`CC'
     String to change terminal's command character.

`cd'
     String to clear the line the cursor is on, and following lines.

`ce'
     String to clear from the cursor to the end of the line.

`ch'
     String to position the cursor at column C in the same line.

`cl'
     String to clear the entire screen and put cursor at upper left
     corner.

`cm'
     String to position the cursor at line L, column C.

`CM'
     String to position the cursor at line L, column C, relative to
     display memory.

`co'
     Number: width of the screen.

`cr'
     String to move cursor sideways to left margin.

`cs'
     String to set the scroll region.

`cS'
     Alternate form of string to set the scroll region.

`ct'
     String to clear all tab stops.

`cv'
     String to position the cursor at line L in the same column.

`da'
     Flag: data scrolled off top of screen may be scrolled back.

`db'
     Flag: data scrolled off bottom of screen may be scrolled back.

`dB'
     Obsolete number: msec of padding needed for the backspace
     character.

`dc'
     String to delete one character position at the cursor.

`dC'
     Obsolete number: msec of padding needed for the carriage-return
     character.

`DC'
     String to delete N characters starting at the cursor.

`dF'
     Obsolete number: msec of padding needed for the formfeed character.

`dl'
     String to delete the line the cursor is on.

`DL'
     String to delete N lines starting with the cursor's line.

`dm'
     String to enter delete mode.

`dN'
     Obsolete number: msec of padding needed for the newline character.

`do'
     String to move the cursor vertically down one line.

`DO'
     String to move cursor vertically down N lines.

`ds'
     String to disable the display of the status line.

`dT'
     Obsolete number: msec of padding needed for the tab character.

`ec'
     String of commands to clear N characters at cursor.

`ed'
     String to exit delete mode.

`ei'
     String to leave insert mode.

`eo'
     Flag: output of a space can erase an overstrike.

`es'
     Flag: other display commands work while writing the status line.

`ff'
     String to advance to the next page, for a hardcopy terminal.

`fs'
     String to move the cursor back from the status line to its
     previous position (outside the status line).

`gn'
     Flag: this terminal type is generic, not real.

`hc'
     Flag: hardcopy terminal.

`hd'
     String to move the cursor down half a line.

`ho'
     String to position cursor at upper left corner.

`hs'
     Flag: the terminal has a status line.

`hu'
     String to move the cursor up half a line.

`hz'
     Flag: terminal cannot accept `~' as output.

`i1'
     String to initialize the terminal for each login session.

`i3'
     String to initialize the terminal for each login session.

`ic'
     String to insert one character position at the cursor.

`IC'
     String to insert N character positions at the cursor.

`if'
     String naming a file of commands to initialize the terminal.

`im'
     String to enter insert mode.

`in'
     Flag: outputting a space is different from moving over empty
     positions.

`ip'
     String to output following an inserted character in insert mode.

`is'
     String to initialize the terminal for each login session.

`it'
     Number: initial spacing between hardware tab stop columns.

`k0'
     String of input sent by function key 0 or 10.

`k1 ... k9'
     Strings of input sent by function keys 1 through 9.

`K1 ... K5'
     Strings sent by the five other keys in 3-by-3 array with arrows.

`ka'
     String of input sent by the "clear all tabs" key.

`kA'
     String of input sent by the "insert line" key.

`kb'
     String of input sent by the "backspace" key.

`kC'
     String of input sent by the "clear screen" key.

`kd'
     String of input sent by typing the down-arrow key.

`kD'
     String of input sent by the "delete character" key.

`ke'
     String to make the function keys work locally.

`kE'
     String of input sent by the "clear to end of line" key.

`kF'
     String of input sent by the "scroll forward" key.

`kh'
     String of input sent by typing the "home-position" key.

`kH'
     String of input sent by the "home down" key.

`kI'
     String of input sent by the "insert character" or "enter insert
     mode" key.

`kl'
     String of input sent by typing the left-arrow key.

`kL'
     String of input sent by the "delete line" key.

`km'
     Flag: the terminal has a Meta key.

`kM'
     String of input sent by the "exit insert mode" key.

`kn'
     Numeric value, the number of numbered function keys.

`kN'
     String of input sent by the "next page" key.

`ko'
     Very obsolete string listing the terminal's named function keys.

`kP'
     String of input sent by the "previous page" key.

`kr'
     String of input sent by typing the right-arrow key.

`kR'
     String of input sent by the "scroll reverse" key.

`ks'
     String to make the function keys transmit.

`kS'
     String of input sent by the "clear to end of screen" key.

`kt'
     String of input sent by the "clear tab stop this column" key.

`kT'
     String of input sent by the "set tab stop in this column" key.

`ku'
     String of input sent by typing the up-arrow key.

`l0'
     String on keyboard labelling function key 0 or 10.

`l1 ... l9'
     Strings on keyboard labelling function keys 1 through 9.

`le'
     String to move the cursor left one column.

`LE'
     String to move cursor left N columns.

`li'
     Number: height of the screen.

`ll'
     String to position cursor at lower left corner.

`lm'
     Number: lines of display memory.

`LP'
     Flag: writing to last column of last line will not scroll.

`mb'
     String to enter blinking mode.

`md'
     String to enter double-bright mode.

`me'
     String to turn off all appearance modes

`mh'
     String to enter half-bright mode.

`mi'
     Flag: cursor motion in insert mode is safe.

`mk'
     String to enter invisible mode.

`mm'
     String to enable the functioning of the Meta key.

`mo'
     String to disable the functioning of the Meta key.

`mp'
     String to enter protected mode.

`mr'
     String to enter reverse-video mode.

`ms'
     Flag: cursor motion in standout mode is safe.

`nc'
     Obsolete flag: do not use ASCII carriage-return on this terminal.

`nd'
     String to move the cursor right one column.

`NF'
     Flag: do not use XON/XOFF flow control.

`nl'
     Obsolete alternative name for the `do' and `sf' capabilities.

`ns'
     Flag: the terminal does not normally scroll for sequential output.

`nw'
     String to move to start of next line, possibly clearing rest of
     old line.

`os'
     Flag: terminal can overstrike.

`pb'
     Number: the lowest baud rate at which padding is actually needed.

`pc'
     String containing character for padding.

`pf'
     String to terminate redirection of output to the printer.

`po'
     String to redirect further output to the printer.

`pO'
     String to redirect N characters ofoutput to the printer.

`ps'
     String to print the screen on the attached printer.

`rc'
     String to move to last saved cursor position.

`RI'
     String to move cursor right N columns.

`rp'
     String to output character C repeated N times.

`rs'
     String to reset the terminal from any strange modes.

`sa'
     String to turn on an arbitrary combination of appearance modes.

`sc'
     String to save the current cursor position.

`se'
     String to leave standout mode.

`sf'
     String to scroll the screen one line up.

`SF'
     String to scroll the screen N lines up.

`sg'
     Number: width of magic standout cookie.  Absent if magic cookies
     are not used.

`so'
     String to enter standout mode.

`sr'
     String to scroll the screen one line down.

`SR'
     String to scroll the screen N line down.

`st'
     String to set tab stop at current cursor column on all lines.
     programs.

`ta'
     String to move the cursor right to the next hardware tab stop
     column.

`te'
     String to return terminal to settings for sequential output.

`ti'
     String to initialize terminal for random cursor motion.

`ts'
     String to move the terminal cursor into the status line.

`uc'
     String to underline one character and move cursor right.

`ue'
     String to turn off underline mode

`ug'
     Number: width of underlining magic cookie.  Absent if underlining
     doesn't use magic cookies.

`ul'
     Flag: underline by overstriking with an underscore.

`up'
     String to move the cursor vertically up one line.

`UP'
     String to move cursor vertically up N lines.

`us'
     String to turn on underline mode

`vb'
     String to make the screen flash.

`ve'
     String to return the cursor to normal.

`vi'
     String to make the cursor invisible.

`vs'
     String to enhance the cursor.

`wi'
     String to set the terminal output screen window.

`ws'
     Number: the width of the status line.

`xb'
     Flag: superbee terminal.

`xn'
     Flag: cursor wraps in a strange way.

`xs'
     Flag: clearing a line is the only way to clear the appearance
     modes of positions in that line (or, only way to remove magic
     cookies on that line).

`xt'
     Flag: Teleray 1061; several strange characteristics.


File: termcap.info,  Node: Var Index,  Next: Cap Index,  Prev: Summary,  Up: Top

Variable and Function Index
***************************

* Menu:

* BC:                                   tgoto.
* ospeed:                               Output Padding.
* PC:                                   Output Padding.
* tgetent:                              Find.
* tgetflag:                             Interrogate.
* tgetnum:                              Interrogate.
* tgetstr:                              Interrogate.
* tgoto:                                tgoto.
* tparam:                               tparam.
* tputs:                                Output Padding.
* UP:                                   tgoto.

