/* fat.h - setups for fat binaries.
   Generated by configure - DO NOT EDIT.  */

#ifndef OPERATION_add_n
#undef  mpn_add_n
#define mpn_add_n  (*__gmpn_cpuvec.add_n)
#endif
DECL_add_n (__MPN(add_n_init));

#ifndef OPERATION_addmul_1
#undef  mpn_addmul_1
#define mpn_addmul_1  (*__gmpn_cpuvec.addmul_1)
#endif
DECL_addmul_1 (__MPN(addmul_1_init));

#ifndef OPERATION_copyd
#undef  mpn_copyd
#define mpn_copyd  (*__gmpn_cpuvec.copyd)
#endif
DECL_copyd (__MPN(copyd_init));

#ifndef OPERATION_copyi
#undef  mpn_copyi
#define mpn_copyi  (*__gmpn_cpuvec.copyi)
#endif
DECL_copyi (__MPN(copyi_init));

#ifndef OPERATION_dive_1
#undef  mpn_divexact_1
#define mpn_divexact_1  (*__gmpn_cpuvec.divexact_1)
#endif
DECL_divexact_1 (__MPN(divexact_1_init));

#ifndef OPERATION_diveby3
#undef  mpn_divexact_by3c
#define mpn_divexact_by3c  (*__gmpn_cpuvec.divexact_by3c)
#endif
DECL_divexact_by3c (__MPN(divexact_by3c_init));

#ifndef OPERATION_divrem_1
#undef  mpn_divrem_1
#define mpn_divrem_1  (*__gmpn_cpuvec.divrem_1)
#endif
DECL_divrem_1 (__MPN(divrem_1_init));

#ifndef OPERATION_gcd_1
#undef  mpn_gcd_1
#define mpn_gcd_1  (*__gmpn_cpuvec.gcd_1)
#endif
DECL_gcd_1 (__MPN(gcd_1_init));

#ifndef OPERATION_lshift
#undef  mpn_lshift
#define mpn_lshift  (*__gmpn_cpuvec.lshift)
#endif
DECL_lshift (__MPN(lshift_init));

#ifndef OPERATION_mod_1
#undef  mpn_mod_1
#define mpn_mod_1  (*__gmpn_cpuvec.mod_1)
#endif
DECL_mod_1 (__MPN(mod_1_init));

#ifndef OPERATION_mod_34lsub1
#undef  mpn_mod_34lsub1
#define mpn_mod_34lsub1  (*__gmpn_cpuvec.mod_34lsub1)
#endif
DECL_mod_34lsub1 (__MPN(mod_34lsub1_init));

#ifndef OPERATION_mode1o
#undef  mpn_modexact_1c_odd
#define mpn_modexact_1c_odd  (*__gmpn_cpuvec.modexact_1c_odd)
#endif
DECL_modexact_1c_odd (__MPN(modexact_1c_odd_init));

#ifndef OPERATION_mul_1
#undef  mpn_mul_1
#define mpn_mul_1  (*__gmpn_cpuvec.mul_1)
#endif
DECL_mul_1 (__MPN(mul_1_init));

#ifndef OPERATION_mul_basecase
#undef  mpn_mul_basecase
#define mpn_mul_basecase  (*__gmpn_cpuvec.mul_basecase)
#endif
DECL_mul_basecase (__MPN(mul_basecase_init));

#ifndef OPERATION_pre_divrem_1
#undef  mpn_preinv_divrem_1
#define mpn_preinv_divrem_1  (*__gmpn_cpuvec.preinv_divrem_1)
#endif
DECL_preinv_divrem_1 (__MPN(preinv_divrem_1_init));

#ifndef OPERATION_pre_mod_1
#undef  mpn_preinv_mod_1
#define mpn_preinv_mod_1  (*__gmpn_cpuvec.preinv_mod_1)
#endif
DECL_preinv_mod_1 (__MPN(preinv_mod_1_init));

#ifndef OPERATION_rshift
#undef  mpn_rshift
#define mpn_rshift  (*__gmpn_cpuvec.rshift)
#endif
DECL_rshift (__MPN(rshift_init));

#ifndef OPERATION_sqr_basecase
#undef  mpn_sqr_basecase
#define mpn_sqr_basecase  (*__gmpn_cpuvec.sqr_basecase)
#endif
DECL_sqr_basecase (__MPN(sqr_basecase_init));

#ifndef OPERATION_sub_n
#undef  mpn_sub_n
#define mpn_sub_n  (*__gmpn_cpuvec.sub_n)
#endif
DECL_sub_n (__MPN(sub_n_init));

#ifndef OPERATION_submul_1
#undef  mpn_submul_1
#define mpn_submul_1  (*__gmpn_cpuvec.submul_1)
#endif
DECL_submul_1 (__MPN(submul_1_init));

/* variable thresholds */
#undef  MUL_KARATSUBA_THRESHOLD
#define MUL_KARATSUBA_THRESHOLD  CPUVEC_THRESHOLD (mul_karatsuba_threshold)
#undef  MUL_TOOM3_THRESHOLD
#define MUL_TOOM3_THRESHOLD  CPUVEC_THRESHOLD (mul_toom3_threshold)
#undef  SQR_KARATSUBA_THRESHOLD
#define SQR_KARATSUBA_THRESHOLD  CPUVEC_THRESHOLD (sqr_karatsuba_threshold)
#undef  SQR_TOOM3_THRESHOLD
#define SQR_TOOM3_THRESHOLD  CPUVEC_THRESHOLD (sqr_toom3_threshold)

/* Copy all fields into __gmpn_cpuvec.
   memcpy is not used because it might operate byte-wise (depending on its
   implemenation), and we need the function pointer writes to be atomic.
   volatile discourages the compiler from trying to optimize this.  */
#define CPUVEC_INSTALL(vec) \
  do { \
    volatile struct cpuvec_t *p = &__gmpn_cpuvec; \
    p->add_n = vec.add_n; \
    p->addmul_1 = vec.addmul_1; \
    p->copyd = vec.copyd; \
    p->copyi = vec.copyi; \
    p->divexact_1 = vec.divexact_1; \
    p->divexact_by3c = vec.divexact_by3c; \
    p->divrem_1 = vec.divrem_1; \
    p->gcd_1 = vec.gcd_1; \
    p->lshift = vec.lshift; \
    p->mod_1 = vec.mod_1; \
    p->mod_34lsub1 = vec.mod_34lsub1; \
    p->modexact_1c_odd = vec.modexact_1c_odd; \
    p->mul_1 = vec.mul_1; \
    p->mul_basecase = vec.mul_basecase; \
    p->preinv_divrem_1 = vec.preinv_divrem_1; \
    p->preinv_mod_1 = vec.preinv_mod_1; \
    p->rshift = vec.rshift; \
    p->sqr_basecase = vec.sqr_basecase; \
    p->sub_n = vec.sub_n; \
    p->submul_1 = vec.submul_1; \
    p->mul_karatsuba_threshold = vec.mul_karatsuba_threshold; \
    p->mul_toom3_threshold = vec.mul_toom3_threshold; \
    p->sqr_karatsuba_threshold = vec.sqr_karatsuba_threshold; \
    p->sqr_toom3_threshold = vec.sqr_toom3_threshold; \
  } while (0)

/* A helper to check all fields are filled. */
#define ASSERT_CPUVEC(vec) \
  do { \
    ASSERT (vec.add_n != NULL); \
    ASSERT (vec.addmul_1 != NULL); \
    ASSERT (vec.copyd != NULL); \
    ASSERT (vec.copyi != NULL); \
    ASSERT (vec.divexact_1 != NULL); \
    ASSERT (vec.divexact_by3c != NULL); \
    ASSERT (vec.divrem_1 != NULL); \
    ASSERT (vec.gcd_1 != NULL); \
    ASSERT (vec.lshift != NULL); \
    ASSERT (vec.mod_1 != NULL); \
    ASSERT (vec.mod_34lsub1 != NULL); \
    ASSERT (vec.modexact_1c_odd != NULL); \
    ASSERT (vec.mul_1 != NULL); \
    ASSERT (vec.mul_basecase != NULL); \
    ASSERT (vec.preinv_divrem_1 != NULL); \
    ASSERT (vec.preinv_mod_1 != NULL); \
    ASSERT (vec.rshift != NULL); \
    ASSERT (vec.sqr_basecase != NULL); \
    ASSERT (vec.sub_n != NULL); \
    ASSERT (vec.submul_1 != NULL); \
    ASSERT (vec.mul_karatsuba_threshold != 0); \
    ASSERT (vec.mul_toom3_threshold != 0); \
    ASSERT (vec.sqr_karatsuba_threshold != 0); \
    ASSERT (vec.sqr_toom3_threshold != 0); \
  } while (0)

/* Call ITERATE(field) for each fat threshold field. */
#define ITERATE_FAT_THRESHOLDS() \
  do { \
    ITERATE (MUL_KARATSUBA_THRESHOLD, mul_karatsuba_threshold); \
    ITERATE (MUL_TOOM3_THRESHOLD, mul_toom3_threshold); \
    ITERATE (SQR_KARATSUBA_THRESHOLD, sqr_karatsuba_threshold); \
    ITERATE (SQR_TOOM3_THRESHOLD, sqr_toom3_threshold); \
  } while (0)

DECL_add_n (__gmpn_add_n_x86);
DECL_addmul_1 (__gmpn_addmul_1_x86);
DECL_copyd (__gmpn_copyd_x86);
DECL_copyi (__gmpn_copyi_x86);
DECL_divexact_1 (__gmpn_divexact_1_x86);
DECL_divrem_1 (__gmpn_divrem_1_x86);
DECL_lshift (__gmpn_lshift_x86);
DECL_mod_1 (__gmpn_mod_1_x86);
DECL_mod_34lsub1 (__gmpn_mod_34lsub1_x86);
DECL_mul_1 (__gmpn_mul_1_x86);
DECL_mul_basecase (__gmpn_mul_basecase_x86);
DECL_rshift (__gmpn_rshift_x86);
DECL_sqr_basecase (__gmpn_sqr_basecase_x86);
DECL_sub_n (__gmpn_sub_n_x86);
DECL_submul_1 (__gmpn_submul_1_x86);

#define CPUVEC_SETUP_x86 \
  do { \
    decided_cpuvec.add_n = __gmpn_add_n_x86; \
    decided_cpuvec.addmul_1 = __gmpn_addmul_1_x86; \
    decided_cpuvec.copyd = __gmpn_copyd_x86; \
    decided_cpuvec.copyi = __gmpn_copyi_x86; \
    decided_cpuvec.divexact_1 = __gmpn_divexact_1_x86; \
    decided_cpuvec.divrem_1 = __gmpn_divrem_1_x86; \
    decided_cpuvec.lshift = __gmpn_lshift_x86; \
    decided_cpuvec.mod_1 = __gmpn_mod_1_x86; \
    decided_cpuvec.mod_34lsub1 = __gmpn_mod_34lsub1_x86; \
    decided_cpuvec.mul_1 = __gmpn_mul_1_x86; \
    decided_cpuvec.mul_basecase = __gmpn_mul_basecase_x86; \
    decided_cpuvec.rshift = __gmpn_rshift_x86; \
    decided_cpuvec.sqr_basecase = __gmpn_sqr_basecase_x86; \
    decided_cpuvec.sub_n = __gmpn_sub_n_x86; \
    decided_cpuvec.submul_1 = __gmpn_submul_1_x86; \
  } while (0)

DECL_divexact_by3c (__gmpn_divexact_by3c_fat);
DECL_gcd_1 (__gmpn_gcd_1_fat);
DECL_modexact_1c_odd (__gmpn_modexact_1c_odd_fat);

#define CPUVEC_SETUP_fat \
  do { \
    decided_cpuvec.mul_karatsuba_threshold = 20; \
    decided_cpuvec.mul_toom3_threshold = 130; \
    decided_cpuvec.sqr_karatsuba_threshold = 30; \
    decided_cpuvec.sqr_toom3_threshold = 200; \
    decided_cpuvec.divexact_by3c = __gmpn_divexact_by3c_fat; \
    decided_cpuvec.gcd_1 = __gmpn_gcd_1_fat; \
    decided_cpuvec.modexact_1c_odd = __gmpn_modexact_1c_odd_fat; \
  } while (0)


#define CPUVEC_SETUP_i486 \
  do { \
    decided_cpuvec.mul_karatsuba_threshold = 18; \
    decided_cpuvec.mul_toom3_threshold = 228; \
    decided_cpuvec.sqr_karatsuba_threshold = 49; \
    decided_cpuvec.sqr_toom3_threshold = 238; \
  } while (0)

DECL_add_n (__gmpn_add_n_k6);
DECL_addmul_1 (__gmpn_addmul_1_k6);
DECL_divrem_1 (__gmpn_divrem_1_k6);
DECL_gcd_1 (__gmpn_gcd_1_k6);
DECL_mod_34lsub1 (__gmpn_mod_34lsub1_k6);
DECL_modexact_1c_odd (__gmpn_modexact_1c_odd_k6);
DECL_mul_1 (__gmpn_mul_1_k6);
DECL_mul_basecase (__gmpn_mul_basecase_k6);
DECL_preinv_mod_1 (__gmpn_preinv_mod_1_k6);
DECL_sqr_basecase (__gmpn_sqr_basecase_k6);
DECL_sub_n (__gmpn_sub_n_k6);
DECL_submul_1 (__gmpn_submul_1_k6);

#define CPUVEC_SETUP_k6 \
  do { \
    decided_cpuvec.mul_karatsuba_threshold = 19; \
    decided_cpuvec.mul_toom3_threshold = 73; \
    decided_cpuvec.sqr_karatsuba_threshold = 32; \
    decided_cpuvec.sqr_toom3_threshold = 105; \
    decided_cpuvec.add_n = __gmpn_add_n_k6; \
    decided_cpuvec.addmul_1 = __gmpn_addmul_1_k6; \
    decided_cpuvec.divrem_1 = __gmpn_divrem_1_k6; \
    decided_cpuvec.gcd_1 = __gmpn_gcd_1_k6; \
    decided_cpuvec.mod_34lsub1 = __gmpn_mod_34lsub1_k6; \
    decided_cpuvec.modexact_1c_odd = __gmpn_modexact_1c_odd_k6; \
    decided_cpuvec.mul_1 = __gmpn_mul_1_k6; \
    decided_cpuvec.mul_basecase = __gmpn_mul_basecase_k6; \
    decided_cpuvec.preinv_mod_1 = __gmpn_preinv_mod_1_k6; \
    decided_cpuvec.sqr_basecase = __gmpn_sqr_basecase_k6; \
    decided_cpuvec.sub_n = __gmpn_sub_n_k6; \
    decided_cpuvec.submul_1 = __gmpn_submul_1_k6; \
  } while (0)

DECL_divexact_1 (__gmpn_divexact_1_k6_mmx);
DECL_lshift (__gmpn_lshift_k6_mmx);
DECL_rshift (__gmpn_rshift_k6_mmx);

#define CPUVEC_SETUP_k6_mmx \
  do { \
    decided_cpuvec.divexact_1 = __gmpn_divexact_1_k6_mmx; \
    decided_cpuvec.lshift = __gmpn_lshift_k6_mmx; \
    decided_cpuvec.rshift = __gmpn_rshift_k6_mmx; \
  } while (0)

DECL_copyd (__gmpn_copyd_k6_k62mmx);
DECL_lshift (__gmpn_lshift_k6_k62mmx);
DECL_rshift (__gmpn_rshift_k6_k62mmx);

#define CPUVEC_SETUP_k6_k62mmx \
  do { \
    decided_cpuvec.copyd = __gmpn_copyd_k6_k62mmx; \
    decided_cpuvec.lshift = __gmpn_lshift_k6_k62mmx; \
    decided_cpuvec.rshift = __gmpn_rshift_k6_k62mmx; \
  } while (0)

DECL_add_n (__gmpn_add_n_k7);
DECL_addmul_1 (__gmpn_addmul_1_k7);
DECL_divexact_1 (__gmpn_divexact_1_k7);
DECL_gcd_1 (__gmpn_gcd_1_k7);
DECL_mod_34lsub1 (__gmpn_mod_34lsub1_k7);
DECL_modexact_1c_odd (__gmpn_modexact_1c_odd_k7);
DECL_mul_1 (__gmpn_mul_1_k7);
DECL_mul_basecase (__gmpn_mul_basecase_k7);
DECL_sqr_basecase (__gmpn_sqr_basecase_k7);
DECL_sub_n (__gmpn_sub_n_k7);
DECL_submul_1 (__gmpn_submul_1_k7);

#define CPUVEC_SETUP_k7 \
  do { \
    decided_cpuvec.mul_karatsuba_threshold = 28; \
    decided_cpuvec.mul_toom3_threshold = 89; \
    decided_cpuvec.sqr_karatsuba_threshold = 52; \
    decided_cpuvec.sqr_toom3_threshold = 89; \
    decided_cpuvec.add_n = __gmpn_add_n_k7; \
    decided_cpuvec.addmul_1 = __gmpn_addmul_1_k7; \
    decided_cpuvec.divexact_1 = __gmpn_divexact_1_k7; \
    decided_cpuvec.gcd_1 = __gmpn_gcd_1_k7; \
    decided_cpuvec.mod_34lsub1 = __gmpn_mod_34lsub1_k7; \
    decided_cpuvec.modexact_1c_odd = __gmpn_modexact_1c_odd_k7; \
    decided_cpuvec.mul_1 = __gmpn_mul_1_k7; \
    decided_cpuvec.mul_basecase = __gmpn_mul_basecase_k7; \
    decided_cpuvec.sqr_basecase = __gmpn_sqr_basecase_k7; \
    decided_cpuvec.sub_n = __gmpn_sub_n_k7; \
    decided_cpuvec.submul_1 = __gmpn_submul_1_k7; \
  } while (0)

DECL_copyd (__gmpn_copyd_k7_mmx);
DECL_copyi (__gmpn_copyi_k7_mmx);
DECL_divrem_1 (__gmpn_divrem_1_k7_mmx);
DECL_preinv_divrem_1 (__gmpn_preinv_divrem_1_k7_mmx);
DECL_lshift (__gmpn_lshift_k7_mmx);
DECL_mod_1 (__gmpn_mod_1_k7_mmx);
DECL_preinv_mod_1 (__gmpn_preinv_mod_1_k7_mmx);
DECL_rshift (__gmpn_rshift_k7_mmx);

#define CPUVEC_SETUP_k7_mmx \
  do { \
    decided_cpuvec.copyd = __gmpn_copyd_k7_mmx; \
    decided_cpuvec.copyi = __gmpn_copyi_k7_mmx; \
    decided_cpuvec.divrem_1 = __gmpn_divrem_1_k7_mmx; \
    decided_cpuvec.preinv_divrem_1 = __gmpn_preinv_divrem_1_k7_mmx; \
    decided_cpuvec.lshift = __gmpn_lshift_k7_mmx; \
    decided_cpuvec.mod_1 = __gmpn_mod_1_k7_mmx; \
    decided_cpuvec.preinv_mod_1 = __gmpn_preinv_mod_1_k7_mmx; \
    decided_cpuvec.rshift = __gmpn_rshift_k7_mmx; \
  } while (0)

DECL_add_n (__gmpn_add_n_pentium);
DECL_addmul_1 (__gmpn_addmul_1_pentium);
DECL_copyd (__gmpn_copyd_pentium);
DECL_copyi (__gmpn_copyi_pentium);
DECL_divexact_1 (__gmpn_divexact_1_pentium);
DECL_lshift (__gmpn_lshift_pentium);
DECL_mod_1 (__gmpn_mod_1_pentium);
DECL_preinv_mod_1 (__gmpn_preinv_mod_1_pentium);
DECL_mod_34lsub1 (__gmpn_mod_34lsub1_pentium);
DECL_modexact_1c_odd (__gmpn_modexact_1c_odd_pentium);
DECL_mul_1 (__gmpn_mul_1_pentium);
DECL_mul_basecase (__gmpn_mul_basecase_pentium);
DECL_rshift (__gmpn_rshift_pentium);
DECL_sqr_basecase (__gmpn_sqr_basecase_pentium);
DECL_sub_n (__gmpn_sub_n_pentium);
DECL_submul_1 (__gmpn_submul_1_pentium);

#define CPUVEC_SETUP_pentium \
  do { \
    decided_cpuvec.mul_karatsuba_threshold = 16; \
    decided_cpuvec.mul_toom3_threshold = 90; \
    decided_cpuvec.sqr_karatsuba_threshold = 22; \
    decided_cpuvec.sqr_toom3_threshold = 122; \
    decided_cpuvec.add_n = __gmpn_add_n_pentium; \
    decided_cpuvec.addmul_1 = __gmpn_addmul_1_pentium; \
    decided_cpuvec.copyd = __gmpn_copyd_pentium; \
    decided_cpuvec.copyi = __gmpn_copyi_pentium; \
    decided_cpuvec.divexact_1 = __gmpn_divexact_1_pentium; \
    decided_cpuvec.lshift = __gmpn_lshift_pentium; \
    decided_cpuvec.mod_1 = __gmpn_mod_1_pentium; \
    decided_cpuvec.preinv_mod_1 = __gmpn_preinv_mod_1_pentium; \
    decided_cpuvec.mod_34lsub1 = __gmpn_mod_34lsub1_pentium; \
    decided_cpuvec.modexact_1c_odd = __gmpn_modexact_1c_odd_pentium; \
    decided_cpuvec.mul_1 = __gmpn_mul_1_pentium; \
    decided_cpuvec.mul_basecase = __gmpn_mul_basecase_pentium; \
    decided_cpuvec.rshift = __gmpn_rshift_pentium; \
    decided_cpuvec.sqr_basecase = __gmpn_sqr_basecase_pentium; \
    decided_cpuvec.sub_n = __gmpn_sub_n_pentium; \
    decided_cpuvec.submul_1 = __gmpn_submul_1_pentium; \
  } while (0)

DECL_lshift (__gmpn_lshift_pentium_mmx);
DECL_mul_1 (__gmpn_mul_1_pentium_mmx);
DECL_rshift (__gmpn_rshift_pentium_mmx);

#define CPUVEC_SETUP_pentium_mmx \
  do { \
    decided_cpuvec.mul_karatsuba_threshold = 16; \
    decided_cpuvec.mul_toom3_threshold = 89; \
    decided_cpuvec.sqr_karatsuba_threshold = 22; \
    decided_cpuvec.sqr_toom3_threshold = 77; \
    decided_cpuvec.lshift = __gmpn_lshift_pentium_mmx; \
    decided_cpuvec.mul_1 = __gmpn_mul_1_pentium_mmx; \
    decided_cpuvec.rshift = __gmpn_rshift_pentium_mmx; \
  } while (0)

DECL_add_n (__gmpn_add_n_p6);
DECL_addmul_1 (__gmpn_addmul_1_p6);
DECL_copyd (__gmpn_copyd_p6);
DECL_divexact_1 (__gmpn_divexact_1_p6);
DECL_mod_1 (__gmpn_mod_1_p6);
DECL_preinv_mod_1 (__gmpn_preinv_mod_1_p6);
DECL_mod_34lsub1 (__gmpn_mod_34lsub1_p6);
DECL_modexact_1c_odd (__gmpn_modexact_1c_odd_p6);
DECL_mul_basecase (__gmpn_mul_basecase_p6);
DECL_sqr_basecase (__gmpn_sqr_basecase_p6);
DECL_sub_n (__gmpn_sub_n_p6);
DECL_submul_1 (__gmpn_submul_1_p6);

#define CPUVEC_SETUP_p6 \
  do { \
    decided_cpuvec.mul_karatsuba_threshold = 23; \
    decided_cpuvec.mul_toom3_threshold = 140; \
    decided_cpuvec.sqr_karatsuba_threshold = 52; \
    decided_cpuvec.sqr_toom3_threshold = 189; \
    decided_cpuvec.add_n = __gmpn_add_n_p6; \
    decided_cpuvec.addmul_1 = __gmpn_addmul_1_p6; \
    decided_cpuvec.copyd = __gmpn_copyd_p6; \
    decided_cpuvec.divexact_1 = __gmpn_divexact_1_p6; \
    decided_cpuvec.mod_1 = __gmpn_mod_1_p6; \
    decided_cpuvec.preinv_mod_1 = __gmpn_preinv_mod_1_p6; \
    decided_cpuvec.mod_34lsub1 = __gmpn_mod_34lsub1_p6; \
    decided_cpuvec.modexact_1c_odd = __gmpn_modexact_1c_odd_p6; \
    decided_cpuvec.mul_basecase = __gmpn_mul_basecase_p6; \
    decided_cpuvec.sqr_basecase = __gmpn_sqr_basecase_p6; \
    decided_cpuvec.sub_n = __gmpn_sub_n_p6; \
    decided_cpuvec.submul_1 = __gmpn_submul_1_p6; \
  } while (0)

DECL_divrem_1 (__gmpn_divrem_1_p6_mmx);
DECL_preinv_divrem_1 (__gmpn_preinv_divrem_1_p6_mmx);
DECL_lshift (__gmpn_lshift_p6_mmx);
DECL_rshift (__gmpn_rshift_p6_mmx);

#define CPUVEC_SETUP_p6_mmx \
  do { \
    decided_cpuvec.mul_karatsuba_threshold = 20; \
    decided_cpuvec.mul_toom3_threshold = 74; \
    decided_cpuvec.sqr_karatsuba_threshold = 30; \
    decided_cpuvec.sqr_toom3_threshold = 101; \
    decided_cpuvec.divrem_1 = __gmpn_divrem_1_p6_mmx; \
    decided_cpuvec.preinv_divrem_1 = __gmpn_preinv_divrem_1_p6_mmx; \
    decided_cpuvec.lshift = __gmpn_lshift_p6_mmx; \
    decided_cpuvec.rshift = __gmpn_rshift_p6_mmx; \
  } while (0)


#define CPUVEC_SETUP_p6_p3mmx \
  do { \
  } while (0)

DECL_addmul_1 (__gmpn_addmul_1_p6_sse2);
DECL_mul_1 (__gmpn_mul_1_p6_sse2);
DECL_mul_basecase (__gmpn_mul_basecase_p6_sse2);
DECL_sqr_basecase (__gmpn_sqr_basecase_p6_sse2);
DECL_submul_1 (__gmpn_submul_1_p6_sse2);

#define CPUVEC_SETUP_p6_sse2 \
  do { \
    decided_cpuvec.mul_karatsuba_threshold = 20; \
    decided_cpuvec.mul_toom3_threshold = 77; \
    decided_cpuvec.sqr_karatsuba_threshold = 30; \
    decided_cpuvec.sqr_toom3_threshold = 101; \
    decided_cpuvec.addmul_1 = __gmpn_addmul_1_p6_sse2; \
    decided_cpuvec.mul_1 = __gmpn_mul_1_p6_sse2; \
    decided_cpuvec.mul_basecase = __gmpn_mul_basecase_p6_sse2; \
    decided_cpuvec.sqr_basecase = __gmpn_sqr_basecase_p6_sse2; \
    decided_cpuvec.submul_1 = __gmpn_submul_1_p6_sse2; \
  } while (0)

DECL_copyd (__gmpn_copyd_pentium4);
DECL_copyi (__gmpn_copyi_pentium4);

#define CPUVEC_SETUP_pentium4 \
  do { \
    decided_cpuvec.copyd = __gmpn_copyd_pentium4; \
    decided_cpuvec.copyi = __gmpn_copyi_pentium4; \
  } while (0)

DECL_lshift (__gmpn_lshift_pentium4_mmx);
DECL_rshift (__gmpn_rshift_pentium4_mmx);

#define CPUVEC_SETUP_pentium4_mmx \
  do { \
    decided_cpuvec.lshift = __gmpn_lshift_pentium4_mmx; \
    decided_cpuvec.rshift = __gmpn_rshift_pentium4_mmx; \
  } while (0)

DECL_add_n (__gmpn_add_n_pentium4_sse2);
DECL_addmul_1 (__gmpn_addmul_1_pentium4_sse2);
DECL_divexact_1 (__gmpn_divexact_1_pentium4_sse2);
DECL_divrem_1 (__gmpn_divrem_1_pentium4_sse2);
DECL_preinv_divrem_1 (__gmpn_preinv_divrem_1_pentium4_sse2);
DECL_mod_1 (__gmpn_mod_1_pentium4_sse2);
DECL_preinv_mod_1 (__gmpn_preinv_mod_1_pentium4_sse2);
DECL_mod_34lsub1 (__gmpn_mod_34lsub1_pentium4_sse2);
DECL_modexact_1c_odd (__gmpn_modexact_1c_odd_pentium4_sse2);
DECL_mul_1 (__gmpn_mul_1_pentium4_sse2);
DECL_mul_basecase (__gmpn_mul_basecase_pentium4_sse2);
DECL_sqr_basecase (__gmpn_sqr_basecase_pentium4_sse2);
DECL_sub_n (__gmpn_sub_n_pentium4_sse2);
DECL_submul_1 (__gmpn_submul_1_pentium4_sse2);

#define CPUVEC_SETUP_pentium4_sse2 \
  do { \
    decided_cpuvec.mul_karatsuba_threshold = 31; \
    decided_cpuvec.mul_toom3_threshold = 119; \
    decided_cpuvec.sqr_karatsuba_threshold = 49; \
    decided_cpuvec.sqr_toom3_threshold = 165; \
    decided_cpuvec.add_n = __gmpn_add_n_pentium4_sse2; \
    decided_cpuvec.addmul_1 = __gmpn_addmul_1_pentium4_sse2; \
    decided_cpuvec.divexact_1 = __gmpn_divexact_1_pentium4_sse2; \
    decided_cpuvec.divrem_1 = __gmpn_divrem_1_pentium4_sse2; \
    decided_cpuvec.preinv_divrem_1 = __gmpn_preinv_divrem_1_pentium4_sse2; \
    decided_cpuvec.mod_1 = __gmpn_mod_1_pentium4_sse2; \
    decided_cpuvec.preinv_mod_1 = __gmpn_preinv_mod_1_pentium4_sse2; \
    decided_cpuvec.mod_34lsub1 = __gmpn_mod_34lsub1_pentium4_sse2; \
    decided_cpuvec.modexact_1c_odd = __gmpn_modexact_1c_odd_pentium4_sse2; \
    decided_cpuvec.mul_1 = __gmpn_mul_1_pentium4_sse2; \
    decided_cpuvec.mul_basecase = __gmpn_mul_basecase_pentium4_sse2; \
    decided_cpuvec.sqr_basecase = __gmpn_sqr_basecase_pentium4_sse2; \
    decided_cpuvec.sub_n = __gmpn_sub_n_pentium4_sse2; \
    decided_cpuvec.submul_1 = __gmpn_submul_1_pentium4_sse2; \
  } while (0)

#define MUL_KARATSUBA_THRESHOLD_LIMIT  31
#define MUL_TOOM3_THRESHOLD_LIMIT  228
#define SQR_KARATSUBA_THRESHOLD_LIMIT  52
#define SQR_TOOM3_THRESHOLD_LIMIT  238
