/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */
#include <stdlib.h>
#include <string.h>

#include "libsupp.h"


error_t
libsupp_argz_append(char **argz, size_t *argz_len, const char *buf, size_t buf_len)
{
  /*
   *  Append BUF, of length BUF_LEN to the argz vector in ARGZ
   *  of length ARGZ_LEN.
   *  If a memory allocation error occurs, ENOMEM is returned,
   *  otherwise 0.
   */

  if (buf_len)
  {
    char *new_argz;
    size_t new_argz_len;

    new_argz_len = *argz_len + buf_len;
    new_argz = realloc(*argz, new_argz_len);
    if (new_argz == NULL)
      return ENOMEM;

    memcpy(new_argz + *argz_len, buf, buf_len);
    *argz = new_argz;
    *argz_len = new_argz_len;
  }

  return 0;
}
