/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */
#include <string.h>

#include "../include/libc/unconst.h"
#include "libsupp.h"


char *
libsupp_argz_next(const char *argz, size_t argz_len, const char *entry)
{
  /*
   *  Return the next entry in ARGZ of length ARGZ_LEN after ENTRY,
   *  or NULL if there are no more.  If entry is NULL, then the first
   *  entry is returned.
   */

  if (entry)
  {
    for (; *entry; entry++)
      ;
    entry++;
    return (entry + 1 > argz + argz_len) ? NULL : unconst(entry, char *);
  }

  return (argz_len > 0) ? unconst(argz, char *) : NULL;
}
