/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */
#include "libsupp.h"

#define EOS  '\0'


void
libsupp_argz_stringify(char *argz, size_t argz_len, int sep)
{
  /*
   *  Make '\0' separated argz vector ARGZ printable by converting
   *  all the '\0's except the last into the character SEP.
   */

  if (argz_len > 1)
  {
    size_t i, i_max;

    i_max = argz_len - 1;
    for (i = 0; i < i_max; i++)
      if (argz[i] == EOS)
        argz[i] = sep;
  }
}
