/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1998 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1994 DJ Delorie, see COPYING.DJ for details */
#include <stdlib.h>
#include <errno.h>

#include "libsupp.h"
#include "dirstruc.h"

int
libsupp_closedir(DIR *dir)
{
  int retval = 0;
  int e = errno;

  errno = 0;
  libsupp_rewinddir(dir);	/* under LFN this closes the search handle */
  if (errno == 0)
    errno = e;
  else
    retval = -1;
  free(dir->name);
  free(dir);
  return retval;
}
