int mmkdir(char *dir)
{
  char *cp, *cp2, c;
  int rv;
  struct ffblk f;
  struct stat s;

  if (dir[1] == ':' && dir[2] == 0)
    return 0;

  if (stat(dir, &s))
  {
    if (access(dir, 0) == 0)
      return 0;
  }
  else
  {
    if ((s.st_mode & S_IFMT) == S_IFDIR)
      return 0;
    return 1;
  }

  rv = mkdir(dir);
  
  if (rv == 0)
    return 0;

  if (errno == EACCES)
    return 1;

  cp = 0;
  for (cp2=dir; *cp2; cp2++)
    if (*cp2=='\\' || *cp2=='/')
      cp = cp2;
  if (cp == 0)
    return 1;
  c = *cp;
  *cp = 0;
  rv = mmkdir(dir);
  *cp = c;
  
  if (rv)
    return 1;
  return mkdir(dir);
}

char *kb(long b)
{
  static char buf[20];
  char *suf = "K";
  if (b < 1000)
  {
    sprintf(buf, "%5ld", b);
    return buf;
  }
  if (b > 1000000L)
  {
    b /= 1000;
    suf = "M";
  }
  if (b < 10000L)
    sprintf(buf, "%ld.%02ld%s", b/1000, b%1000/10, suf);
  else if (b < 100000L)
    sprintf(buf, "%ld.%01ld%s", b/1000, b%1000/100, suf);
  else
    sprintf(buf, "%4ld%s", b/1000, suf);
  return buf;
}

long show_free_space()
{
  int drive = 0;
  struct dfree dtable;
  char dletter;
  long fr;

  if (install_dir[1] == ':')
  {
    drive = install_dir[0] & 0x1f;
    dletter = drive + '@';
  }
  else
    dletter = getdisk() + 'A';
  getdfree(drive, &dtable);
  fr = (long)dtable.df_avail * dtable.df_bsec * dtable.df_sclus;
  printf("Disk %s%c:%s has %s%s%s available.\n",
         ansibold, dletter, ansinorm, ansibold, kb(fr), ansinorm);
  return fr;
}

long copyfile(char *src, char *dest)
{
  int destf, srcf, rd;
  long copied = 0;
  char buf[4096];

  srcf = _open(src, O_RDONLY);
  if (srcf < 0)
  {
    printf("Cannot open %s for reading\n", src);
    exit(1);
  }
  destf = _creat(dest, 0);

  if (destf < 0)
  {
    printf("Cannot open %s for writing\n", dest);
    perror("The error was");
    exit(1);
  }
  
  while ((rd = read(srcf, buf, 4096)) > 0)
  {
    write(destf, buf, rd);
    copied += rd;
  }

  close(srcf);
  close(destf);
  
  return copied;
}
