#ifndef _FPU_EMU_SCHED_H
#define _FPU_EMU_SCHED_H

/*
  Replacement for the Linux sched.h header file.
  */


#include <linux/math_emu.h>

#ifndef NULL
#define NULL ((void *) 0)
#endif

extern void schedule(void);

struct i387_hard_struct {
};

struct i387_soft_struct {
	long	cwd;
	long	swd;
	long	twd;
	long	fip;
	long	fcs;
	long	foo;
	long	fos;
	long    top;
	struct fpu_reg	regs[8];	/* 8*16 bytes for each FP-reg = 128 bytes */
	unsigned char	lookahead;
	unsigned long	entry_eip;
};

union i387_union {
	struct i387_hard_struct hard;
	struct i387_soft_struct soft;
};


struct tss_struct {
       unsigned long   trap_no, error_code;
 };

struct task_struct {
	unsigned long flags;
	unsigned short used_math;
/* tss for this task */
        struct tss_struct tss;
};

#define PF_PTRACED	0x00000010

extern struct task_struct _current;
#define current (& _current)

/* Not multi-tasking, never need resched */
#define need_resched 0

extern int send_sig(unsigned long sig,struct task_struct * p,int priv);

#endif
