/*------------------------------------------------------------
 * 
 *  winsch.c
 * 
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  inserts a char at the cursor position in a window
 *  rightmost char on line falls off
 * 
 *----------------------------------------------------------*/

#include "curses.h"

int
winsch(win, ch)
WINDOW  *win;
int     ch;
{
    int cury, curx, cnt;
    VIDCHR *ptr;

    getyx(win, cury, curx);
    cnt = win->maxx - curx;
    markwin(win);
    ptr = &(win->buf[cury][curx + cnt]);
    memcpy(ptr + 1, ptr, cnt * sizeof(VIDCHR));
    win->buf[cury][curx].chr = ch;
    win->buf[cury][curx].att = win->attrib;
    wmove(win, cury, win->maxx);
    markwin(win);
    wmove(win, cury, curx);

    return OK;
}
