#include "fntool.h"

static void badfna(void)
{
	fatalerr("invalid \".fna\" file: \"%s\"",inname);
}

static void readbitmap(chr *cp,char *rowp)
{
	int  xx,yy;

	for(xx = 0; (rowp[xx] == '#') || (rowp[xx] == '.'); xx++);
	cp->width = xx;
	cp->bmp = makebytemap(cp->width,fnt.height);
	for(yy = 0; yy < fnt.height; yy++) {
	    if(yy != 0) rowp = readline();
	    for(xx = 0; xx < cp->width; xx++) {
		switch(*rowp++) {
		    case '#': cp->bmp[yy][xx] = 1; break;
		    case '.': cp->bmp[yy][xx] = 0; break;
		    default:  badfna();
		}
	    }
	}
}

void readfna(void)
{
	char *p;
	char param[100],value[100];
	chr  *cp,*last;
	int  code;

	code = 0;
	last = NULL;
	fnt.isfixed = 1;
	for( ; ; ) {
	    p = readline();
	    switch(p[0]) {
	      case ' ':
	      case ';':
	      case '\r':
	      case '\n':
	      case '\t':
		continue;
	      case '.':
	      case '#':
		cp = safemalloc(sizeof(chr));
		readbitmap(cp,p);
		cp->next = NULL;
		*(last ? &last->next : &fnt.chars) = cp;
		last = cp;
		if(code < fnt.minchar) code = fnt.minchar;
		cp->code = code;
		if(++code > fnt.maxchar) break;
		continue;
	      default:
		param[0] = '\0';
		if(sscanf(p,"%s %s",param,value) < 2)
		    { if(!strmatch(param,"note")) badfna(); }
		else if(strmatch(param,"name"))
		    strcpy(fnt.name,value);
		else if(strmatch(param,"family"))
		    strcpy(fnt.family,value);
		else if(strmatch(param,"width"))
		    fnt.minwidth = fnt.maxwidth = fnt.avgwidth = atoi(value);
		else if(strmatch(param,"height"))
		    fnt.height = atoi(value);
		else if(strmatch(param,"minchar"))
		    fnt.minchar = atoi(value);
		else if(strmatch(param,"maxchar"))
		    fnt.maxchar = atoi(value);
		else if(strmatch(param,"minwidth"))
		    fnt.minwidth = atoi(value);
		else if(strmatch(param,"maxwidth"))
		    fnt.maxwidth = atoi(value);
		else if(strmatch(param,"avgwidth"))
		    fnt.avgwidth = atoi(value);
		else if(strmatch(param,"isfixed"))
		    fnt.isfixed = atoi(value);
		else if(strmatch(param,"undwidth"))
		    fnt.undwidth = atoi(value);
		else if(strmatch(param,"baseline"))
		    fnt.baseline = atoi(value);
		else if(strmatch(param,"note"))
		    strcat(notes,&p[5]);
		else badfna();
		continue;
	    }
	    break;
	}
	splitfamily();
	if(fnt.undwidth == 0) fnt.undwidth = (fnt.height / 20) + 1;
	if(fnt.baseline == 0) {
	    fnt.baseline = fnt.height - 1;
	    if((cp = getchr('a')) != NULL) {
		while((fnt.baseline > 0) && !rowbit(cp->bmp,fnt.baseline)) {
		    fnt.baseline--;
		}
	    }
	}
}

