/** 
 ** BYTEDRAW.H 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#ifndef _BYTEDRAW_H_
#define _BYTEDRAW_H_

#ifdef  __TURBOC__
#pragma inline
#endif

/*
 * utilities -- other files may define them too
 */
#ifndef _SaveDS

#ifdef  __TURBOC__
#define _ClrDir()	asm cld
#define _SetDir()	asm std
#define _SaveDS()	asm push    ds
#define _RestoreDS()	asm pop	    ds
#endif

#ifdef  __GNUC__
#define _ASV		asm volatile
#define _ClrDir()	_ASV("cld")
#define _SetDir()	_ASV("std")
#define _SaveDS()
#define _RestoreDS()
#endif

#endif  /* _SaveDS */

#ifdef  __TURBOC__
/*
 * display a bit mapped font character (both FGC and BGC)
 */
#define __WRTFONT__(dst,offs,fontbits,wdt,hgt,colors,putbyte) do {	\
    _BX = hgt;								\
    _DX = colors;							\
    asm les	di,DWORD PTR dst;					\
    asm lds	si,DWORD PTR fontbits;					\
  Font##putbyte##NextRow:						\
    asm mov	cx,WORD PTR wdt;					\
  Font##putbyte##ReadBits:						\
    asm lodsb;								\
    asm mov	ah,al;							\
    asm stc;								\
    asm adc	ah,ah;							\
  Font##putbyte##Loop:							\
    asm sbb	al,al;							\
    asm and	al,dh;							\
    asm xor	al,dl;							\
    putbyte;								\
    asm add	ah,ah;							\
    asm loopnz  Font##putbyte##Loop;					\
    asm or	cx,cx;							\
    asm jnz	Font##putbyte##ReadBits;				\
    asm add	di,WORD PTR offs;					\
    asm dec	bx;							\
    asm jnz	Font##putbyte##NextRow;					\
} while(0)

/*
 * display a bit mapped font character (FGC or BGC only)
 */
#define __WR1CFNT__(dst,offs,fontbits,wdt,hgt,color,jump,opr) do {	\
    _BX = hgt;								\
    _DL = color;							\
    asm les	di,DWORD PTR dst;					\
    asm lds	si,DWORD PTR fontbits;					\
  Font##jump##opr##NextRow:						\
    asm mov	cx,WORD PTR wdt;					\
  Font##jump##opr##ReadBits:						\
    asm lodsb;								\
    asm stc;								\
    asm adc	al,al;							\
  Font##jump##opr##Loop:						\
    asm jump	Font##jump##opr##NoSet;					\
    asm opr	BYTE PTR es:[di],dl;					\
  Font##jump##opr##NoSet:						\
    asm inc	di;							\
    asm add	al,al;							\
    asm loopnz  Font##jump##opr##Loop;					\
    asm or	cx,cx;							\
    asm jnz	Font##jump##opr##ReadBits;				\
    asm add	di,WORD PTR offs;					\
    asm dec	bx;							\
    asm jnz	Font##jump##opr##NextRow;				\
} while(0)

#define __WFSET__	asm stosb
#define __WFXOR__	asm xor	  BYTE PTR es:[di],al; asm inc	 di
#define __WFOR__	asm or	  BYTE PTR es:[di],al; asm inc	 di
#define __WFAND__	asm and	  BYTE PTR es:[di],al; asm inc	 di

#define _WriteFont(dp,o,bp,w,h,cls)	__WRTFONT__(dp,o,bp,w,h,cls,__WFSET__)
#define _WriteFontXor(dp,o,bp,w,h,cls)  __WRTFONT__(dp,o,bp,w,h,cls,__WFXOR__)
#define _WriteFontOr(dp,o,bp,w,h,cls)	__WRTFONT__(dp,o,bp,w,h,cls,__WFOR__)
#define _WriteFontAnd(dp,o,bp,w,h,cls)  __WRTFONT__(dp,o,bp,w,h,cls,__WFAND__)

#define _WrFGCFont(dp,o,bp,w,h,fg)	__WR1CFNT__(dp,o,bp,w,h,fg,jnc,mov)
#define _WrFGCFontXor(dp,o,bp,w,h,fg)	__WR1CFNT__(dp,o,bp,w,h,fg,jnc,xor)
#define _WrFGCFontOr(dp,o,bp,w,h,fg)	__WR1CFNT__(dp,o,bp,w,h,fg,jnc,or)
#define _WrFGCFontAnd(dp,o,bp,w,h,fg)	__WR1CFNT__(dp,o,bp,w,h,fg,jnc,and)

#define _WrBGCFont(dp,o,bp,w,h,bg)	__WR1CFNT__(dp,o,bp,w,h,bg,jc,mov)
#define _WrBGCFontXor(dp,o,bp,w,h,bg)	__WR1CFNT__(dp,o,bp,w,h,bg,jc,xor)
#define _WrBGCFontOr(dp,o,bp,w,h,bg)	__WR1CFNT__(dp,o,bp,w,h,bg,jc,or)
#define _WrBGCFontAnd(dp,o,bp,w,h,bg)	__WR1CFNT__(dp,o,bp,w,h,bg,jc,and)

/*
 * set a bitmap patterned row
 */
#define __PTNROW__(dst,maskpatt,width,colors,putbyte) do {		\
    _DX = maskpatt;							\
    _CX = width;							\
    _BX = colors;							\
    asm les	di,DWORD PTR dst;					\
    asm sub	bl,bh;							\
  Patt##putbyte##Loop:							\
    asm rol	dl,1;							\
    asm sbb	al,al;							\
    asm and	al,bh;							\
    asm xor	al,bl;							\
    putbyte;								\
    asm loop	Patt##putbyte##Loop;					\
} while(0)

/*
 * set a bitmap patterned row, foreground only
 */
#define __P1CROW__(dst,maskpatt,width,color,jump,opr) do {		\
    _DX = maskpatt;							\
    _CX = width;							\
    _AX = color;							\
    asm les	di,DWORD PTR dst;					\
  Patt##jump##opr##Loop:						\
    asm rol	dl,1;							\
    asm jump	Patt##jump##opr##NoSet;					\
    asm opr	BYTE PTR es:[di],al;					\
  Patt##jump##opr##NoSet:						\
    asm inc	di;							\
    asm loop	Patt##jump##opr##Loop;					\
} while(0)

#define _PatternSet(dst,msk,wdt,cls)	__PTNROW__(dst,msk,wdt,cls,__WFSET__)
#define _PatternXor(dst,msk,wdt,cls)	__PTNROW__(dst,msk,wdt,cls,__WFXOR__)
#define _PatternOr(dst,msk,wdt,cls)	__PTNROW__(dst,msk,wdt,cls,__WFOR__)
#define _PatternAnd(dst,msk,wdt,cls)	__PTNROW__(dst,msk,wdt,cls,__WFAND__)

#define _PattFGCSet(dst,msk,wdt,fg)	__P1CROW__(dst,msk,wdt,fg,jnc,mov)
#define _PattFGCXor(dst,msk,wdt,fg)	__P1CROW__(dst,msk,wdt,fg,jnc,xor)
#define _PattFGCOr(dst,msk,wdt,fg)	__P1CROW__(dst,msk,wdt,fg,jnc,or)
#define _PattFGCAnd(dst,msk,wdt,fg)	__P1CROW__(dst,msk,wdt,fg,jnc,and)

#define _PattBGCSet(dst,msk,wdt,bg)	__P1CROW__(dst,msk,wdt,bg,jc,mov)
#define _PattBGCXor(dst,msk,wdt,bg)	__P1CROW__(dst,msk,wdt,bg,jc,xor)
#define _PattBGCOr(dst,msk,wdt,bg)	__P1CROW__(dst,msk,wdt,bg,jc,or)
#define _PattBGCAnd(dst,msk,wdt,bg)	__P1CROW__(dst,msk,wdt,bg,jc,and)

/*
 * X major line drawing
 */
#define __XLINE__(dst,offs,deltx,delty,color,putbyte) do {		\
    _CX = deltx;							\
    _BX = delty;							\
    _AX = color;							\
    _SI = offs;								\
    asm les	di,dst;							\
    asm mov	dx,cx;							\
    asm shr	dx,1;							\
    asm inc	cx;							\
  LineX##putbyte##Loop:							\
    putbyte;								\
    asm sub	dx,bx;							\
    asm jnc	LineX##putbyte##NoAdjust;				\
    asm add	dx,WORD PTR deltx;					\
    asm add	di,si;							\
  LineX##putbyte##NoAdjust:						\
    asm loop	LineX##putbyte##Loop;					\
} while(0)

#define __XLSET__	asm stosb
#define __XLXOR__	asm xor	  BYTE PTR es:[di],al; asm inc	 di
#define __XLOR__	asm or	  BYTE PTR es:[di],al; asm inc	 di
#define __XLAND__	asm and	  BYTE PTR es:[di],al; asm inc	 di

#define _DrawXLine(dp,do,dx,dy,c)	__XLINE__(dp,do,dx,dy,c,__XLSET__)
#define _DrawXLineXor(dp,do,dx,dy,c)	__XLINE__(dp,do,dx,dy,c,__XLXOR__)
#define _DrawXLineOr(dp,do,dx,dy,c)	__XLINE__(dp,do,dx,dy,c,__XLOR__)
#define _DrawXLineAnd(dp,do,dx,dy,c)	__XLINE__(dp,do,dx,dy,c,__XLAND__)

/*
 * Y major line drawing
 */
#define __YLINE__(dst,offs,deltx,delty,color,putbyte) do {		\
    _CX = delty;							\
    _BX = deltx;							\
    _AX = color;							\
    _SI = offs;								\
    asm les	di,dst;							\
    asm mov	dx,cx;							\
    asm shr	dx,1;							\
    asm inc	cx;							\
  LineY##putbyte##Loop:							\
    putbyte;								\
    asm add	di,si;							\
    asm sub	dx,bx;							\
    asm jnc	LineY##putbyte##NoAdjust;				\
    asm add	dx,WORD PTR delty;					\
    asm inc	di;							\
  LineY##putbyte##NoAdjust:						\
    asm loop	LineY##putbyte##Loop;					\
} while(0)

#define __YLSET__	asm mov	  BYTE PTR es:[di],al
#define __YLXOR__	asm xor	  BYTE PTR es:[di],al
#define __YLOR__	asm or	  BYTE PTR es:[di],al
#define __YLAND__	asm and	  BYTE PTR es:[di],al

#define _DrawYLine(dp,do,dx,dy,c)	__YLINE__(dp,do,dx,dy,c,__YLSET__)
#define _DrawYLineXor(dp,do,dx,dy,c)	__YLINE__(dp,do,dx,dy,c,__YLXOR__)
#define _DrawYLineOr(dp,do,dx,dy,c)	__YLINE__(dp,do,dx,dy,c,__YLOR__)
#define _DrawYLineAnd(dp,do,dx,dy,c)	__YLINE__(dp,do,dx,dy,c,__YLAND__)
#endif  /* __TURBOC__ */

#ifdef  __GNUC__
/*
 * display a bit mapped font character (both FGC and BGC)
 */
#define __WRTFONT__(dst,offs,bits,wdt,hgt,colors,putbyte) _ASV("      \n\
	movl	%0,%%edi					      \n\
	movl	%2,%%esi					      \n\
	movl	%4,%%ebx					      \n\
	movl	%5,%%edx					      \n\
L_Font"#putbyte"NextRow:					      \n\
	movl	%3,%%ecx					      \n\
L_Font"#putbyte"ReadBits:					      \n\
	lodsb							      \n\
	movb	%%al,%%ah					      \n\
	stc							      \n\
	adcb	%%ah,%%ah					      \n\
L_Font"#putbyte"Loop:						      \n\
	sbbb	%%al,%%al					      \n\
	andb	%%dh,%%al					      \n\
	xorb	%%dl,%%al					      \n\
	"putbyte"						      \n\
	addb	%%ah,%%ah					      \n\
	loopnz  L_Font"#putbyte"Loop				      \n\
	orl	%%ecx,%%ecx					      \n\
	jnz	L_Font"#putbyte"ReadBits			      \n\
	addl	%1,%%edi					      \n\
	decl	%%ebx						      \n\
	jnz	L_Font"#putbyte"NextRow				       "\
	: /* NOTHING */							\
	: "g" (dst), "g" (offs), "g" (bits),				\
	  "g" (wdt), "g" (hgt),  "g" (colors)				\
	: "di", "si", "dx", "cx", "bx", "ax"				\
)

/*
 * display a bit mapped font character (FGC or BGC only)
 */
#define __WR1CFNT__(dst,offs,bits,wdt,hgt,color,jump,opr)     _ASV("  \n\
	movl	%0,%%edi					      \n\
	movl	%2,%%esi					      \n\
	movl	%4,%%ebx					      \n\
	movl	%5,%%edx					      \n\
L_Font"jump opr"NextRow:					      \n\
	movl	%3,%%ecx					      \n\
L_Font"jump opr"ReadBits:					      \n\
	lodsb							      \n\
	stc							      \n\
	adcb	%%al,%%al					      \n\
L_Font"jump opr"Loop:						      \n\
	"jump"  L_Font"jump opr"NoSet				      \n\
	"opr"b  %%dl,(%%edi)					      \n\
L_Font"jump opr"NoSet:						      \n\
	incl	%%edi						      \n\
	addb	%%al,%%al					      \n\
	loopnz  L_Font"jump opr"Loop				      \n\
	orl	%%ecx,%%ecx					      \n\
	jnz	L_Font"jump opr"ReadBits			      \n\
	addl	%1,%%edi					      \n\
	decl	%%ebx						      \n\
	jnz	L_Font"jump opr"NextRow				       "\
	: /* NOTHING */							\
	: "g" (dst), "g" (offs), "g" (bits),				\
	  "g" (wdt), "g" (hgt),  "g" (color)				\
	: "di", "si", "dx", "cx", "bx", "ax"				\
)

#define __WFSET__	"stosb"
#define __WFXOR__	"xorb   %%al,(%%edi); incl  %%edi"
#define __WFOR__	"orb    %%al,(%%edi); incl  %%edi"
#define __WFAND__	"andb   %%al,(%%edi); incl  %%edi"

#define _WriteFont(dp,o,bp,w,h,cls)	__WRTFONT__(dp,o,bp,w,h,cls,__WFSET__)
#define _WriteFontXor(dp,o,bp,w,h,cls)  __WRTFONT__(dp,o,bp,w,h,cls,__WFXOR__)
#define _WriteFontOr(dp,o,bp,w,h,cls)	__WRTFONT__(dp,o,bp,w,h,cls,__WFOR__)
#define _WriteFontAnd(dp,o,bp,w,h,cls)  __WRTFONT__(dp,o,bp,w,h,cls,__WFAND__)

#define _WrFGCFont(dp,o,bp,w,h,fg)	__WR1CFNT__(dp,o,bp,w,h,fg,"jnc","mov")
#define _WrFGCFontXor(dp,o,bp,w,h,fg)	__WR1CFNT__(dp,o,bp,w,h,fg,"jnc","xor")
#define _WrFGCFontOr(dp,o,bp,w,h,fg)	__WR1CFNT__(dp,o,bp,w,h,fg,"jnc","or")
#define _WrFGCFontAnd(dp,o,bp,w,h,fg)	__WR1CFNT__(dp,o,bp,w,h,fg,"jnc","and")

#define _WrBGCFont(dp,o,bp,w,h,bg)	__WR1CFNT__(dp,o,bp,w,h,bg,"jc","mov")
#define _WrBGCFontXor(dp,o,bp,w,h,bg)	__WR1CFNT__(dp,o,bp,w,h,bg,"jc","xor")
#define _WrBGCFontOr(dp,o,bp,w,h,bg)	__WR1CFNT__(dp,o,bp,w,h,bg,"jc","or")
#define _WrBGCFontAnd(dp,o,bp,w,h,bg)	__WR1CFNT__(dp,o,bp,w,h,bg,"jc","and")

/*
 * set a bitmap patterned row
 */
#define __PTNROW__(dst,maskpatt,width,colors,putbyte) _ASV("          \n\
	movl	%0,%%edi					      \n\
	movl	%1,%%edx					      \n\
	movl	%2,%%ecx					      \n\
	movl	%3,%%ebx					      \n\
L_Patt"#putbyte"Loop:						      \n\
	rolb	$1,%%dl						      \n\
	sbbb	%%al,%%al					      \n\
	andb	%%bh,%%al					      \n\
	xorb	%%bl,%%al					      \n\
	"putbyte"						      \n\
	loop	L_Patt"#putbyte"Loop				       "\
	: /* NOTHING */							\
	: "g" (dst), "g" (maskpatt), "g" (width), "g" (colors)		\
	: "di", "dx", "cx", "bx", "ax"					\
)

/*
 * set a bitmap patterned row, foreground or background only
 */
#define __P1CROW__(dst,maskpatt,width,color,jump,opr) _ASV("          \n\
	movl	%0,%%edi					      \n\
	movl	%1,%%edx					      \n\
	movl	%2,%%ecx					      \n\
	movl	%3,%%eax					      \n\
L_Patt"jump opr"Loop:						      \n\
	rolb	$1,%%dl						      \n\
	"jump"  L_Patt"jump opr"NoSet				      \n\
	"opr"b  %%al,(%%edi)					      \n\
L_Patt"jump opr"NoSet:						      \n\
	incl	%%edi						      \n\
	loop	L_Patt"jump opr"Loop				      \n\
L_Patt"jump opr"End:						       "\
	: /* NOTHING */							\
	: "g" (dst), "g" (maskpatt), "g" (width), "g" (color)		\
	: "di", "dx", "cx", "ax"					\
)

#define _PatternSet(dst,msk,wdt,cls)	__PTNROW__(dst,msk,wdt,cls,__WFSET__)
#define _PatternXor(dst,msk,wdt,cls)	__PTNROW__(dst,msk,wdt,cls,__WFXOR__)
#define _PatternOr(dst,msk,wdt,cls)	__PTNROW__(dst,msk,wdt,cls,__WFOR__)
#define _PatternAnd(dst,msk,wdt,cls)	__PTNROW__(dst,msk,wdt,cls,__WFAND__)

#define _PattFGCSet(dst,msk,wdt,fg)	__P1CROW__(dst,msk,wdt,fg,"jnc","mov")
#define _PattFGCXor(dst,msk,wdt,fg)	__P1CROW__(dst,msk,wdt,fg,"jnc","xor")
#define _PattFGCOr(dst,msk,wdt,fg)	__P1CROW__(dst,msk,wdt,fg,"jnc","or")
#define _PattFGCAnd(dst,msk,wdt,fg)	__P1CROW__(dst,msk,wdt,fg,"jnc","and")

#define _PattBGCSet(dst,msk,wdt,bg)	__P1CROW__(dst,msk,wdt,bg,"jc","mov")
#define _PattBGCXor(dst,msk,wdt,bg)	__P1CROW__(dst,msk,wdt,bg,"jc","xor")
#define _PattBGCOr(dst,msk,wdt,bg)	__P1CROW__(dst,msk,wdt,bg,"jc","or")
#define _PattBGCAnd(dst,msk,wdt,bg)	__P1CROW__(dst,msk,wdt,bg,"jc","and")

/*
 * X major line drawing
 */
#define __XLINE__(dst,offs,deltx,delty,color,putbyte) _ASV("          \n\
	movl	%0,%%edi					      \n\
	movl	%1,%%esi					      \n\
	movl	%2,%%ecx					      \n\
	movl	%3,%%ebx					      \n\
	movl	%4,%%eax					      \n\
	movl	%%ecx,%%edx					      \n\
	shrl	$1,%%edx					      \n\
	incl	%%ecx						      \n\
L_LineX"#putbyte"Loop:						      \n\
	"putbyte"						      \n\
	subl	%%ebx,%%edx					      \n\
	jnc	L_LineX"#putbyte"NoAdjust			      \n\
	addl	%2,%%edx					      \n\
	addl	%%esi,%%edi					      \n\
L_LineX"#putbyte"NoAdjust:					      \n\
	loop	L_LineX"#putbyte"Loop				       "\
	: /* NOTHING */							\
	: "g" (dst), "g" (offs), "g" (deltx), "g" (delty), "g" (color)  \
	: "di", "si", "dx", "cx", "bx", "ax"				\
)

#define __XLSET__	"stosb"
#define __XLXOR__	"xorb   %%al,(%%edi); incl  %%edi"
#define __XLOR__	"orb    %%al,(%%edi); incl  %%edi"
#define __XLAND__	"andb   %%al,(%%edi); incl  %%edi"

#define _DrawXLine(dp,do,dx,dy,c)	__XLINE__(dp,do,dx,dy,c,__XLSET__)
#define _DrawXLineXor(dp,do,dx,dy,c)	__XLINE__(dp,do,dx,dy,c,__XLXOR__)
#define _DrawXLineOr(dp,do,dx,dy,c)	__XLINE__(dp,do,dx,dy,c,__XLOR__)
#define _DrawXLineAnd(dp,do,dx,dy,c)	__XLINE__(dp,do,dx,dy,c,__XLAND__)

/*
 * Y major line drawing
 */
#define __YLINE__(dst,offs,deltx,delty,color,putbyte) _ASV("          \n\
	movl	%0,%%edi					      \n\
	movl	%1,%%esi					      \n\
	movl	%3,%%ecx					      \n\
	movl	%2,%%ebx					      \n\
	movl	%4,%%eax					      \n\
	movl	%%ecx,%%edx					      \n\
	shrl	$1,%%edx					      \n\
	incl	%%ecx						      \n\
L_LineY"#putbyte"Loop:						      \n\
	"putbyte"						      \n\
	addl	%%esi,%%edi					      \n\
	subl	%%ebx,%%edx					      \n\
	jnc	L_LineY"#putbyte"NoAdjust			      \n\
	addl	%3,%%edx					      \n\
	incl	%%edi						      \n\
L_LineY"#putbyte"NoAdjust:					      \n\
	loop	L_LineY"#putbyte"Loop				       "\
	: /* NOTHING */							\
	: "g" (dst), "g" (offs), "g" (deltx), "g" (delty), "g" (color)  \
	: "di", "si", "dx", "cx", "bx", "ax"				\
)

#define __YLSET__	"movb   %%al,(%%edi)"
#define __YLXOR__	"xorb   %%al,(%%edi)"
#define __YLOR__	"orb    %%al,(%%edi)"
#define __YLAND__	"andb   %%al,(%%edi)"

#define _DrawYLine(dp,do,dx,dy,c)	__YLINE__(dp,do,dx,dy,c,__YLSET__)
#define _DrawYLineXor(dp,do,dx,dy,c)	__YLINE__(dp,do,dx,dy,c,__YLXOR__)
#define _DrawYLineOr(dp,do,dx,dy,c)	__YLINE__(dp,do,dx,dy,c,__YLOR__)
#define _DrawYLineAnd(dp,do,dx,dy,c)	__YLINE__(dp,do,dx,dy,c,__YLAND__)
#endif  /* __GNUC__ */

#endif  /* whole file */

