/**
 ** CONTEXT.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"
#include "clipping.h"
#include "gmalloc.h"

#include <string.h>

GrContext *GrCreateContext(int w,int h,char far *memory,GrContext *where)
{
	long size   = GrContextSize(w,h);
	long psize  = GrPlaneSize(w,h);
	int  offset = GrLineOffset(w);
	int  flags  = 0;

	if(size == 0L) return(NULL);
#ifdef _MAXMEMPLANESIZE
	if(psize > _MAXMEMPLANESIZE) return(NULL);
#endif
	if(where == NULL) {
	    where = _GrMalloc(sizeof(GrContext));
	    if(where == NULL) return(NULL);
	    flags |= GCM_MYCONTEXT;
	}
	memset(where,0,sizeof(GrContext));
	if(memory == (char far *)NULL) {
	    memory = _GrFarMalloc(size);
	    if(memory == (char far *)NULL)
		{ if(flags) _GrFree(where); return(NULL); }
	    flags |= GCM_MYMEMORY;
	}
	where->gc_baseaddr    = memory;
	where->gc_lineoffset  = offset;
	where->gc_frameaddr   = BASE_ADDRESS(where);
	where->gc_memflags    = flags;
	where->gc_planeoffset = (long)((char huge *)where->gc_planeoffset + psize);
	where->gc_xmax = where->gc_xcliphi = w - 1;
	where->gc_ymax = where->gc_ycliphi = h - 1;
	return(where);
}

#undef  WHEN_OUTSIDE
#define WHEN_OUTSIDE	return(NULL)

GrContext *GrCreateSubContext
	  (int x1,int y1,int x2,int y2,GrContext *parent,GrContext *where)
{
	int flags = 0;

	if(parent == NULL) parent = CURC;
	if(parent->gc_root != NULL) {
	    x1 += parent->gc_xoffset;
	    y1 += parent->gc_yoffset;
	    x2 += parent->gc_xoffset;
	    y2 += parent->gc_yoffset;
	    parent = parent->gc_root;
	}
	CLIPBOXTOCONTEXT(parent,x1,y1,x2,y2);
	if(where == NULL) {
	    where = _GrMalloc(sizeof(GrContext));
	    if(where == NULL) return(NULL);
	    flags |= GCM_MYCONTEXT;
	}
	*where = *parent;
	where->gc_frameaddr = PIX_ADDR(parent,x1,y1);
	where->gc_memflags  = flags;
	where->gc_xoffset   = x1;
	where->gc_yoffset   = y1;
	where->gc_xcliphi   = where->gc_xmax = x2 - x1;
	where->gc_ycliphi   = where->gc_ymax = y2 - y1;
	where->gc_xcliplo   = 0;
	where->gc_ycliplo   = 0;
	where->gc_root	    = parent;
	return(where);
}

#undef  WHEN_OUTSIDE
#define WHEN_OUTSIDE	return

void GrResizeSubContext(GrContext *context,int x1,int y1,int x2,int y2)
{
	GrContext *parent;

	if((parent = context->gc_root) == NULL) return;
	x1 += context->gc_xoffset;
	y1 += context->gc_yoffset;
	x2 += context->gc_xoffset;
	y2 += context->gc_yoffset;
	CLIPBOXTOCONTEXT(parent,x1,y1,x2,y2);
	context->gc_frameaddr = PIX_ADDR(parent,x1,y1);
	context->gc_xoffset   = x1;
	context->gc_yoffset   = y1;
	context->gc_xcliphi   = context->gc_xmax = x2 - x1;
	context->gc_ycliphi   = context->gc_ymax = y2 - y1;
	context->gc_xcliplo   = 0;
	context->gc_ycliplo   = 0;
}

void GrDestroyContext(GrContext *cxt)
{
	if((cxt != NULL) && (cxt != CURC) && (cxt != SCREEN)) {
	    if(cxt->gc_memflags & GCM_MYMEMORY)  _GrFarFree(cxt->gc_baseaddr);
	    if(cxt->gc_memflags & GCM_MYCONTEXT) _GrFree(cxt);
	}
}

void GrSetContext(GrContext *context)
{
	if(context == NULL) context = SCREEN;
	_GrContext = *context;
	_GrMouseCheck =
	    (_GrMouseDrawn && (CURC->gc_baseaddr == SCREEN->gc_baseaddr)) ?
		TRUE :
		FALSE;
}

GrContext *GrSaveContext(GrContext *where)
{
	int flags = 0;

	if(where == NULL) {
	    where = _GrMalloc(sizeof(GrContext));
	    if(where == NULL) return(NULL);
	    flags |= GCM_MYCONTEXT;
	}
	*where = _GrContext;
	where->gc_memflags = flags;
	return(where);
}

