/**
 ** P16.H
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"

typedef unsigned short far *pixptr;	/* pixel pointer */
#define C_SIGNIF    0xffff		/* significant bits in a color */
extern  int _GrPHDrawTable[];		/* drawing control table */

#ifdef _INLINE32K
# define P_ADDRESS(cxt,off)  ((pixptr)(off))
#else
# define P_ADDRESS(cxt,off)  ((pixptr)(					\
     (cxt)->gc_baseaddr +						\
     ((unsigned)(COORD_Y(off) * (cxt)->gc_lineoffset)) +		\
     ((unsigned)(COORD_X(off) << 1))					\
))
#endif

