/**
 ** P4CHAR.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p4.h"
#include "memfill.h"
#include "memcopy.h"
#include "bitdraw.h"

void _GrP4DrawChar(long a,int wdt,int hgt,char far *bits,int fg,int bg)
{
	char far *bb;
	pixptr pp,p = P_ADDRESS(CURC,a);
	int fgop = C_OPER(fg);
	int bgop = C_OPER(bg);
	int shift  = P_OFFSET(a);
	int drawfg = _GrP4DrawTable[fgop] ^ (fg &= C_SIGNIF);
	int drawbg = _GrP4DrawTable[bgop] ^ (bg &= C_SIGNIF);
	int offset = CURC->gc_lineoffset;
	int bitwdt = (wdt + 7) >> 3;
	int plane,mask,hh;

	if((wdt <= 0) || (hgt <= 0)) return;
	if((drawfg | drawbg) == 0) return;
	if((mask = P_OFFSET((int)a + wdt)) != 0) {
	    wdt -= mask;
	    mask = (unsigned char)(0xff00 >> mask);
	}
	wdt = (wdt + 7) >> 3;
	_ClrDir();
	if(CURC->gc_onscreen) {
	    if(drawbg) {
		pp = p;
		_SetVideoColor(bg,bgop);
		if(fgop == C_SET) {
		    int wdt2 = wdt;
		    int msk2 = mask;
		    if(shift) {
			int lmask = 0xff >> shift;
			if(--wdt2 < 0) { lmask &= msk2; msk2 = 0; }
			_SetVGAWriteMask(lmask);
			_ColSetXorB(VLEFT,pp,offset,0,hgt);
			pp++;
		    }
		    if(wdt2 > 0) {
			_SetVGAWriteMask(0xff);
			plane = offset - wdt2;
			if(bgop == C_SET)
			    _BlkSetB(VBODY,pp,plane,0,wdt2,hgt);
			else {
			    _SaveDS();
			    _BlkCpyB(VBODY,pp,plane,pp,plane,wdt2,hgt);
			    _RestoreDS();
			}
			pp += wdt2;
		    }
		    if(msk2) {
			_SetVGAWriteMask(msk2);
			_ColSetXorB(VRIGHT,pp,offset,0,hgt);
		    }
		}
		else if(_GrAdapterType == GR_VGA) {
		    _SetVGAWriteMode(8+3);
		    _SetVGAWriteMask(0xff);
		    _SetVGADontCareRegister(0x00);
		    _SaveDS();
		    for(bb = bits,hh = hgt; --hh >= 0; ) {
			_CharBGRowVGA(pp,bb,wdt,shift,mask);
			pp += offset;
			bb += bitwdt;
		    }
		    _RestoreDS();
		    _SetVGAWriteMode(0);
		}
		else {
		    _SetVGAWriteMask(0xff);
		    _SaveDS();
		    for(bb = bits,hh = hgt; --hh >= 0; ) {
			_CharBGRowEGA(pp,bb,wdt,shift,mask);
			pp += offset;
			bb += bitwdt;
		    }
		    _RestoreDS();
		}
	    }
	    if(drawfg) {
		_SetVideoColor(fg,fgop);
		_SetVGAWriteMask(0xff);
		if(_GrAdapterType == GR_VGA) {
		    _SetVGAWriteMode(8+3);
		    _SetVGADontCareRegister(0x00);
		    _SaveDS();
		    while(--hgt >= 0) {
			_CharFGRowVGA(p,bits,wdt,shift,mask);
			p += offset;
			bits += bitwdt;
		    }
		    _RestoreDS();
		    _SetVGAWriteMode(0);
		}
		else {
		    _SaveDS();
		    while(--hgt >= 0) {
			_CharFGRowEGA(p,bits,wdt,shift,mask);
			p += offset;
			bits += bitwdt;
		    }
		    _RestoreDS();
		}
	    }
	    return;
	}
	fgop <<= 1;
	bgop <<= 2;
	for(plane = 4; --plane >= 0; fg >>= 1,bg >>= 1) {
	    _SaveDS();
	    if(drawfg) for(pp = p,bb = bits,hh = hgt; --hh >= 0; ) {
		switch(fgop | (fg & 1)) {
		  case C_XOR2+1:
		    _CharFGRowXor(pp,bb,wdt,shift,mask);
		    break;
		  case C_OR2+1:
		  case C_SET2+1:
		    _CharFGRowOr(pp,bb,wdt,shift,mask);
		    break;
		  case C_AND2+0:
		  case C_SET2+0:
		    _CharFGRowAnd(pp,bb,wdt,shift,mask);
		    break;
		}
		pp += offset;
		bb += bitwdt;
	    }
	    if(drawbg) for(pp = p,bb = bits,hh = hgt; --hh >= 0; ) {
		switch(fgop | (fg & 1)) {
		  case C_XOR2+1:
		    _CharBGRowXor(pp,bb,wdt,shift,mask);
		    break;
		  case C_OR2+1:
		  case C_SET2+1:
		    _CharBGRowOr(pp,bb,wdt,shift,mask);
		    break;
		  case C_AND2+0:
		  case C_SET2+0:
		    _CharBGRowAnd(pp,bb,wdt,shift,mask);
		    break;
		}
		pp += offset;
		bb += bitwdt;
	    }
	    _RestoreDS();
	    p = (pixptr)((long)p + CURC->gc_planeoffset);
	}
}

