/** 
 ** P4PIXROW.C 
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p4.h"
#include "memfill.h"
#include "memcopy.h"

void _GrP4SetPixRow(long addr,int color,int width)
{
	pixptr p = P_ADDRESS(CURC,addr);
	int opr = C_OPER(color);
	int plane,lmask,rmask;

	if(width <= 0) return;
	if((_GrP4DrawTable[opr] ^ (color &= C_SIGNIF)) == 0) return;
	_ClrDir();
	_ComputeMasks(addr,width,lmask,rmask);
	if(CURC->gc_onscreen) {
	    _SetVideoColor(color,opr);
	    if(lmask) { _SetVGAWriteMask(lmask); (*p)++; p++; }
	    if(width) {
		_SetVGAWriteMask(0xff);
		if(opr == C_SET)
		    _RowSetB(VRAM,p,0,width);
		else {
		    _SaveDS();
		    _RowCpyB(VRAM,p,p,width);
		    _RestoreDS();
		}
		p += width;
	    }
	    if(rmask) { _SetVGAWriteMask(rmask); (*p)++; }
	    return;
	}
	opr <<= 1;
	for(plane = 4; --plane >= 0; color >>= 1) {
	    pixptr pp = p;
	    switch(opr | (color & 1)) {
	      case C_XOR2+1:
		if(lmask) { *pp++ ^= lmask; }
		if(width) { _RowSetXorB(MEM_X,pp,0xff,width); pp += width; }
		if(rmask) { *pp ^= rmask; }
		break;
	      case C_OR2+1:
	      case C_SET2+1:
		if(lmask) { *pp++ |= lmask; }
		if(width) { _RowSetB(MEM_1,pp,0xff,width); pp += width; }
		if(rmask) { *pp |= rmask; }
		break;
	      case C_AND2+0:
	      case C_SET2+0:
		if(lmask) { *pp++ &= ~lmask; }
		if(width) { _RowSetB(MEM_0,pp,0,width); pp += width; }
		if(rmask) { *pp &= ~rmask; }
		break;
	    }
	    p = (pixptr)((long)p + CURC->gc_planeoffset);
	}
}

