/**
 ** SOLIDLN.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"
#include "lineclip.h"

/*
 * Used internally by various complex filled primitives
 * It is the same as 'GrLIne', but gets the color as a pointer
 * and does not have to worry about the mouse.
 */
void _GrDrawSolidLine(int x1,int y1,int x2,int y2,void *color)
{
	int c = *((int *)color);

	if(y1 == y2) {
	    CLIPHLINE(CURC,x1,x2,y1);
	    _GrSetPixRow(PIXEL_ADDR(x1,y1),c,(x2 - x1 + 1));
	}
	else if(x1 == x2) {
	    CLIPVLINE(CURC,x1,y1,y2);
	    _GrSetPixColumn(PIXEL_ADDR(x1,y1),c,(y2 - y1 + 1));
	}
	else {
	    CLIPLINE(CURC,x1,y1,x2,y2);
	    _GrDrawLine(PIXEL_ADDR(x1,y1),c,(x2 - x1),(y2 - y1));
	}
}

/*
 * called by the polygon scan routines in XOR mode when drawing the
 * X-major borders typically makes things worse than before
 */
void _GrDummySolidLine(int x1,int y1,int x2,int y2,void *color)
{
	return;
}

