/*****************************************************************************
*  
*                                  DESQview/X 
*                           BASIC DATAGRAM DAEMON TESTER
*
*  The following code is used to test the basic datagram daeomon (UDAEMON.C).
*
*
******************************************************************************/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <netdb.h>		
#include <netinet\in.h>	
#include <sys\time.h>
#include <sys\socket.h>
#include <sys\errno.h>
#include <sys\ioctl.h>


#define TEST_SERVICE	"udptest"

void	chat(int s);

void main(int argc, char *argv[])
{
	int		s;
	struct	sockaddr_in	addr;
	struct	hostent		*h;
	struct	servent		*serv;
	char						sbuff[81];

	if(argc < 2){
		printf("\n\nUsage %s <host>\n\n",argv[0]);
		exit(1);
	}

	/* Open a datagram (UDP) socket */

	s = socket(AF_INET,SOCK_DGRAM,0);

	if(s < 0){

		printf("\nError:  Could not open datagram socket.\n");

		exit(2);
	}

	/* Bind (name) the socket.  A zero address tells the kernel to */
	/* name the socket giving it the sin_addr of the local host  	*/
	/* with any available port.												*/

	memset(&addr, 0, sizeof(struct sockaddr_in));

	addr.sin_family = AF_INET;

    if(bind(s,(struct sockaddr *) &addr,sizeof(addr))){

		printf("\nError:  Could not bind datagram socket.\n");

		exit(3);

	}		
		

	/* Retrieve the information about the port (service) that we	*/
	/* wish to send the datagram to.											*/

	serv = getservbyname(TEST_SERVICE,"udp");

	if(serv == NULL){

		printf("\nError:  Unable to retrieve information for %s service.\n",TEST_SERVICE);

		exit(4);
	}

	/* Now get the host (address) information for the destination	*/
	/* host and fill the destination address structure giving it	*/
	/* the address from the host information and the port from		*/
	/* the retrieved service information.									*/

	h = gethostbyname(argv[1]);

	if(h == NULL){

		printf("\nError:  Unknown host name specified.\n");

		exit(5);
	}

	memset(&addr,0,sizeof(struct sockaddr_in));

	addr.sin_family	= AF_INET;
	addr.sin_addr		= *((struct in_addr *)(h->h_addr));
	addr.sin_port		= serv->s_port;
			

	/* Get some input from the user and send a datagram to the 		*/
	/* destination daemon.														*/

	printf("\nEnter your message:\n\n");

	gets(sbuff);

	if(strlen(sbuff) > 0){
	
		sendto(s, sbuff, strlen(sbuff) + 1, 0,(struct sockaddr *) &addr, sizeof(addr));

		printf("\n\nMessage sent.\n\n");

	}
	so_close(s);
}

