/* Project SWORD
   V2.0

   SubSystem : Basic functions usefull for all the system
   File      : Src/Common/Debug.CC
   Author    : Eric NICOLAS
   Overview  : Debugging system with spy file.
   UpDate    : Oct 23, 1994

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <stdio.h>
#include <stdarg.h>
#include "Common/Debug.H"

#define OpenDebug    FileDebug=fopen("C:/DEBUG.TXT","at+")
#define CreateDebug  FileDebug=fopen("C:/DEBUG.TXT","wt")
#define CloseDebug   fclose(FileDebug)

FILE *FileDebug;
char  ModeDebug;

void InitDebug(char Mode)
{ ModeDebug=Mode;
  if (ModeDebug & DebugON)
  { CreateDebug;
    fprintf(FileDebug,"SWORD 2.0. Debugging file\n"
                      "-------------------------\n\n");
    if (ModeDebug & DebugTemporary) CloseDebug;
  }
}

void DoneDebug()
{ if (ModeDebug & DebugON)
  { if (!(ModeDebug & DebugTemporary)) CloseDebug;
  }
}

void Debug(va_list arg_list, ...)
{  va_list arg_ptr ;
   char *format;
   if (ModeDebug & DebugTemporary) OpenDebug;
   va_start(arg_ptr, arg_list);
   format = (char*)arg_list;
   vfprintf(FileDebug,format, arg_ptr);
   fflush(FileDebug);
   if (ModeDebug & DebugTemporary) CloseDebug;
}
