/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Src/Graphics/Colors.CC
   Author    : Eric NICOLAS
   Overview  : Managing of colors, dithering
   UpDate    : Oct 10, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"

// ----- Global variables

int ColorMode;
int NoSysColor[16];
int SysColorGroup[5][4] =
	  { { 0, 13, 14, 15 },
	    { 0,  4,  5,  6 },
	    { 0,  7,  8,  9 },
	    { 0, 10, 11, 12 },
        { 0,  1,  2,  3 }
      };

// ----- Local variables

int Palette_16c[16][3] =
  { {   0,   0,   0 },
    { 125,  63,  12 },
    { 186, 141,   0 },
    { 255, 255,   0 },
    {   0,   0, 191 },
    {   0, 170, 170 },
    {  85, 255, 255 },
    {  48, 140,  43 },
    {  60, 182,  60 },
    {  85, 255,  85 },
    { 153,  44,  44 },
    { 198,  60,  60 },
    { 250,  80,  80 },
    {  90,  90,  90 },
    { 170, 170, 170 },
    { 255, 255, 255 } };

int Palette_256c[11][3] =
  { { 125,  63,  12 },
    { 186, 141,   0 },
    {   0, 170, 170 },
    {  48, 140,  43 },
    {  60, 182,  60 },
    {  85, 255,  85 },
    { 153,  44,  44 },
    { 198,  60,  60 },
    { 250,  80,  80 },
    {  90,  90,  90 },
    { 170, 170, 170 } };


int *NoColor;

#ifdef __TURBOC__
  #define rbits    4
  #define gbits    4
  #define bbits    4
  #define accurate 2
  #define tot      4
  #define tr       16
  #define tg       16
  #define tb       16
  #define FN       "%sTURBO%d.COL"
#else
  #define rbits    5
  #define gbits    5
  #define bbits    5
  #define accurate 4
  #define tot      16
  #define tr       32
  #define tg       32
  #define tb       32
  #define FN       "%sGNU%d.COL"
#endif

#define V_Table(r,g,b,n) Table[(n)+tot*((b)+tb*((g)+tg*(r)))]

// ----- Object TDither : Used when in True Color (do nothing)

TDither::TDither()
{ }

TDither::~TDither()
{ }

int TDither::GetRGBColor(int, int, int R, int G, int B)
{ return GrAllocColor(R,G,B);
}

// ----- Object TGosselinkDither : Used when in 16 or 256 colors

struct TGosselinkDither : TDither
{ byte *Table;
  // Constructor / Destructor
  TGosselinkDither();
  virtual ~TGosselinkDither();
  // Usefull method
  virtual int GetRGBColor(int X, int Y, int R, int G, int B);
};

TGosselinkDither::TGosselinkDither()
{ char   FileName[200];
  TDisk *FileIn;
  // Kepp memory space for the Table
  Table=new byte[tr*tb*tg*tot];
  // Build the file name
  if (ColorMode==colMODE_16) sprintf(FileName,FN,SwordPath,16);
                        else sprintf(FileName,FN,SwordPath,256);
  // Load the table
  FileIn=new TDisk(FileName,stOpen);
  FileIn->Read(Table,tr*tb*tg*tot);
  delete FileIn;
}

TGosselinkDither::~TGosselinkDither()
{ delete Table;
}

int TGosselinkDither::GetRGBColor(int X, int Y, int R, int G, int B)
{ return NoColor[
		 V_Table( ( R >> (8-rbits)) & (tr-1),
			  ( G >> (8-gbits)) & (tg-1),
			  ( B >> (8-bbits)) & (tb-1),
			  (X & (accurate-1)) + (Y & (accurate-1)) * accurate
			)
			  ];
}

// -----

TDither *Dither;

// ----- Global functions

void InitColors(void)
{ int i;
/*  int j,k,l,m;
  int X,Y;*/
  // Get the mode for color gestion
  switch(GrNumColors())
  { case 16  : ColorMode=colMODE_16;        break;
    case 256 : ColorMode=colMODE_256;       break;
    default  : ColorMode=colMODE_TrueColor; break;
  }
  Debug("  COLORS...    ColorMode      = %d -> ",ColorMode);
  // Initialize and show the palette entries when not in TrueColor
  switch(ColorMode)
  { case colMODE_16  :
      NoColor=new int[16];
	  for(i=0;i<16;i++)
      { NoColor[i]=GrAllocColor(Palette_16c[i][0],Palette_16c[i][1],Palette_16c[i][2]);
//	    GrFilledBox(i*10,0,i*10+9,9,NoColor[i]);
      }
	  Debug(" 16 colors\n");
	  break;
    case colMODE_256 :
	  NoColor=new int[256];
	  for(i=0;i<245;i++)
	  { NoColor[i]=GrAllocColor( ((i/35) % 7)*255/6, ((i/5) % 7)*255/6, (i % 5)*255/4);
/*        k=i%35;
	    l=i/35;
 	    GrFilledBox(k*6,l*6,k*6+5,l*6+5,NoColor[i]);*/
	  }
      for(i=0;i<11;i++)
	  NoColor[i+245]=GrAllocColor(Palette_256c[i][0],Palette_256c[i][1],Palette_256c[i][2]);
      Debug(" 256 colors\n");
      break;
    case colMODE_TrueColor :
      Debug(" True color\n");
      break;
  }
  // Get the system colors from the existing palette
  for(i=0;i<16;i++)
    NoSysColor[i]=GrAllocColor(Palette_16c[i][0],Palette_16c[i][1],Palette_16c[i][2]);
  // Initialize the Dithering system
  switch(ColorMode)
  { case colMODE_16  :
    case colMODE_256 :
      Dither=new TGosselinkDither();
      break;
    case colMODE_TrueColor :
      Dither=new TDither();
      break;
  }
/*
  // Show the effect of dithering
  // Over the boxes : Blue
  // In a box       : Horizontally : Red,  Vertically : Green
  for(k=0;k<32;k++)
  { l=k%16;
    m=k/16;
    GrBox(5+l*40-1,300+m*40-1,5+l*40+32,300+m*40+32,NoSysColor[15]);
    for(i=0;i<32;i++)
      for(j=0;j<32;j++)
      { X=i+5+l*40;
	Y=j+300+m*40;
	GrPlot(X,Y,Dither->GetRGBColor(X,Y,i*255/31,j*255/31,k*255/31));
      }
  }
  getc(stdin);*/
}

void DoneColors(void)
{ delete Dither;
  delete NoColor;
}
