## Project SWORD
#  V2.0
#
#  File      : Src/Makefile.INC
#  Author    : Eric NICOLAS
#  Overview  : Automatic Makefile
#  UpDate    : Nov 16, 1995
#
## Copyright (C) 1993,1995 The SWORD Group
##
## This file is distributed under the terms listed in the document
## "copying.en". A copy of "copying.en" should accompany this file.
## if not, a copy should be available from where this file was obtained.
## This file may not be distributed without a verbatim copy of "copying.en".
##
## This file is distributed WITHOUT ANY WARRANTY; without even the implied
## warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

#
# Implicit Rules
#

%.o: %.cc
	gcc -c -O -I$(INCLUDE) $< -o $@

%.d: %.cc
	gcc -E -MMD -I$(INCLUDE) $< -o $@

#
# Auto-Targets
#

OBJECTS  = $(SOURCES:.cc=.o)
DEPENDS  = $(SOURCES:.cc=.d)
LIBRARY  = $(LIB)/libSWORD.a

#
# Build library
#

$(LIBRARY): $(OBJECTS)
	ar rvs $(LIBRARY) $(OBJECTS)

default: $(LIBRARY)

depend: $(DEPENDS)
	- copy *.d depend.inc

clean:
	- del *.o
	- del *.d
	- del *.bak

all: clean depend default

#
# Dependencies
#

include depend.inc