/* Project SWORD
   V2.0

   SubSystem  : Basic objects, General use mecanisms
   CommandNos : 1100..1199
   File       : Src/Mecanism/Object.CC
   Author     : Eric NICOLAS
   Overview   : Basic object : Events, Selections, Data exchange
   UpDate     : Oct 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"

// Global variables

short RegTObject;
char *IdentTObject = "TObject";

// Constructor, Destructor

TObject::TObject(void) : TAtom()
{ Options=Status=0;
  Register=RegTObject;
  Ident=IdentTObject;
}

TObject::~TObject(void)
{ if (!Destroyed)
  { Done();
    Destroyed=TRUE;
  }
}

void TObject::InitAfterInsert(void)
{ }

// Events

void TObject::DispatchEvent(TEvent *Event)
{ boolean PurgeEvent;
  if (Event->What != evNothing)
  { switch(Event->What)
    { // Mouse
      case evMouseLDown : PurgeEvent=MouseLDown(Event->Where,Event->Buttons);      break;
      case evMouseRDown : PurgeEvent=MouseRDown(Event->Where,Event->Buttons);      break;
      case evMouseLUp   : PurgeEvent=MouseLUp(Event->Where,Event->Buttons);        break;
      case evMouseRUp   : PurgeEvent=MouseRUp(Event->Where,Event->Buttons);        break;
      case evMouseDblCl : PurgeEvent=MouseDblClc(Event->Where,Event->Buttons);     break;
      case evMouseMove  : PurgeEvent=MouseMove(Event->Where,Event->Buttons);       break;
      // Keyboard
      case evKeyDown    : PurgeEvent=KeyDown(Event->ScanCode);                     break;
      case evToggleKey  : PurgeEvent=ToggleKey();                                  break;
      // Time
      case evTime       : PurgeEvent=Time();                                       break;
      case evDate       : PurgeEvent=Date();                                       break;
      // Commands
      case evCommand    : PurgeEvent=HandleCommand(Event->Command,
	                                               Event->Info08b,
                                                   Event->Info16b,
                                                   Event->Info32b,
                                                   Event->InfoPtr);                break;
      // Auto event
      case evAuto      : PurgeEvent=AutoEvt();                                     break;
    }
    if (PurgeEvent) ClearEvent(Event);
  }
}

void TObject::DealEvent(TEvent* Event)
{ TObject *O,*Od;
  int      S=Event->Options & evOpBackward;
  if (Son()!=NULL)
  { Od=Son();
    if (S) Od=Od->Last();
    if (Event->What & evFocused)
    { // It the event is a 'evFocus' one, Deal it only to
      // sons that own the focus
	   O=Od;
	   while((O!=NULL) && (Event->What!=evNothing))
	   { if (O->Focus()) O->HandleEvent(Event);
	     if (S) O=O->Previous(); else O=O->Next();
	   }
	   // Then, deal it to sons that do not own the focus, but
       // that must receive all events
	   O=Od;
	   while((O!=NULL) && (Event->What!=evNothing))
	   { if (O->GetOptions(opGetAllEvents))
           if (!(O->Focus())) O->HandleEvent(Event);
	     if (S) O=O->Previous(); else O=O->Next();
	   }
    }
    else
    { // For other kind of event, Deal it to all sons
      O=Od;
	   while((O!=NULL) & (Event->What!=evNothing))
	   { O->HandleEvent(Event);
	     if (S) O=O->Previous(); else O=O->Next();
	   }
    }
  }
}

void TObject::HandleEvent(TEvent* Event)
{ DealEvent(Event);
  DispatchEvent(Event);
}

void TObject::ClearEvent(TEvent *Event)
{ Event->What=evNothing;
  Event->InfoPtr=this;
}

void TObject::SetEvent(TEvent* Event)
{ if (Father()!=NULL) Father()->SetEvent(Event);
}

void TObject::GetEvent(TEvent* Event)
{ if (Father()!=NULL) Father()->GetEvent(Event);
                 else Event->What=evNothing;
}

long TObject::Exec(void)
{ //return Shell->EventsLoop(this);
  return 0;
}

void TObject::SetCommand(long Command)
{ TEvent Event;
  Event.What=evCommand;
  Event.Command=Command;
  SetEvent(&Event);
}

void TObject::SetCommand(long Command, char Info08b)
{ TEvent Event;
  Event.What=evCommand;
  Event.Command=Command;
  Event.Info08b=Info08b;
  SetEvent(&Event);
}

void TObject::SetCommand(long Command, short Info16b)
{ TEvent Event;
  Event.What=evCommand;
  Event.Command=Command;
  Event.Info16b=Info16b;
  SetEvent(&Event);
}

void TObject::SetCommand(long Command, long Info32b)
{ TEvent Event;
  Event.What=evCommand;
  Event.Command=Command;
  Event.Info32b=Info32b;
  SetEvent(&Event);
}

void TObject::SetCommand(long Command, void *InfoPtr)
{ TEvent Event;
  Event.What=evCommand;
  Event.Command=Command;
  Event.InfoPtr=InfoPtr;
  SetEvent(&Event);
}

// :: :: Mouse

boolean TObject::MouseLDown(TPoint& , int )
{ return FALSE; }

boolean TObject::MouseRDown(TPoint& , int )
{ return FALSE; }

boolean TObject::MouseLUp(TPoint& , int )
{ return FALSE; }

boolean TObject::MouseRUp(TPoint& , int )
{ return FALSE; }

boolean TObject::MouseDblClc(TPoint& , int )
{ return FALSE; }

boolean TObject::MouseMove(TPoint& , int )
{ return FALSE; }

// :: :: Keyboard

boolean TObject::KeyDown(int ScanCode)
{ if (GetStatus(sfSelected))
    switch(ScanCode)
    { case ScanTab      :
        SelectNext();
        return TRUE;
      case ScanShiftTab :
	     SelectPrevious();
        return TRUE;
    }
  return FALSE;
}

boolean TObject::ToggleKey()
{ return FALSE; }

// :: :: Time

boolean TObject::Time()
{ return FALSE; }

boolean TObject::Date()
{ return FALSE; }

// :: :: Commands

boolean TObject::HandleCommand(long , char , short , long , void *)
{ return FALSE; }

// :: :: Auto event

boolean TObject::AutoEvt(void)
{ return FALSE; }

// Selections

void TObject::Select(void)
{ TObject* O;
  if (GetOptions(opSelectable))
    if (!GetStatus(sfSelected))
    { // UnSelect other objects in the current list
      O=First();
      while (O!=NULL)
      { O->UnSelect();
        O=O->Next();
      }
      // Put the sfSelected bit
      SetStatus(sfSelected);
      // Tell to himself and to all sons that we are now selected
      TEvent Event;
      Event.What=evCommand;
      Event.Command=cmSelect;
      HandleEvent(&Event);
    }
}

void TObject::UnSelect(void)
{ if (GetOptions(opSelectable))
  { if (GetStatus(sfSelected))
    { // Tell to himself and to all sons that we will be no more selected
      TEvent Event;
      Event.What=evCommand;
      Event.Command=cmUnSelect;
      HandleEvent(&Event);
      // Clear the sfSelected bit
      ClearStatus(sfSelected);
    }
  }
}

void TObject::SelectNext(void)
{ TObject* O=this;
  do
  { O=O->Next();
    if (O==NULL) O=First();
  } while(  (!O->GetOptions(opSelectable))  ||
            (O->GetStatus(sfDisabled))
         );
  O->Select();
}

void TObject::SelectPrevious(void)
{ TObject* O=this;
  do
  { O=O->Previous();
    if (O==NULL) O=Last();
  } while( (!O->GetOptions(opSelectable)) ||
           (O->GetStatus(sfDisabled))
         );
  O->Select();
}

boolean TObject::Focus(void)
{ if (GetStatus(sfSelected)) return Father()->Focus();
                        else return FALSE;
}

// Linked lists

void TObject::Insert(TAtom* A)
{ TAtom::Insert(A);
  ((TObject*)A)->InitAfterInsert();
  ((TObject*)A)->Select();
}

// Objects streams

TAtom* TObject::Duplicate(void)
{ return new TObject();
}

void TObject::Read(TDisk *file)
{ TAtom::Read(file);
  ReadInt(file,&Status);
  ReadInt(file,&Options);
  ClearStatus(sfSelected);
}

void TObject::Write(TDisk *file)
{ TAtom::Write(file);
  WriteInt(file,Status);
  WriteInt(file,Options);
}

// Data exchange

long TObject::DataSize(void)
{ long     Result=0;
  TObject *O=Son();
  while(O!=NULL)
  { Result+=O->DataSize();
    O=O->Next();
  }
  return Result;
}

void TObject::GetData(void *Ptr)
{ TObject *O=Son();
  char    *P=(char*)Ptr;
  while(O!=NULL)
  { O->GetData(P);
    P+=O->DataSize();
    O=O->Next();
  }
}

void TObject::SetData(void *Ptr)
{ TObject *O=Son();
  char    *P=(char*)Ptr;
  while(O!=NULL)
  { O->SetData(P);
    P+=O->DataSize();
    O=O->Next();
  }
}
