/* Project SWORD
   V2.0

   SubSystem : Basic objects, General use mecanisms
   File      : Src/Mecanism/Setup.CC
   Author    : Eric NICOLAS
   Overview  : Global system's configuration
   UpDate    : Oct 02, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Disk.H"
#include "Mecanism/Setup.H"
#include <dos.h>

TSetUp SetUp;

void InitSetUp(void)
{ TDisk     *FileIn;
  char       FileName[200];
  union REGS regs;
  // Build the full name for the SWORD2.CFG setup file
  sprintf(FileName,"%sSWORD.CFG",SwordPath);
  // Try to open and readthis file
  FileIn=new TDisk(FileName,stOpen);
  FileIn->Read(&SetUp,sizeof(TSetUp));
  // Check an error in openning and reading the file
  if (Error)
  { // If the file is not available, set default values
    Error=0;
    // :: System Font = Helvetica, 14pts
    strcpy(SetUp.SystemFontName,"HELV14");
    // :: Screen Parameters
    SetUp.ScreenX=640;
    SetUp.ScreenY=480;
    SetUp.ScreenColors=16;
    // :: Auto Detect DOS parameters
    // :: :: DOS version
    regs.h.ah=0x30;
    int86(0x21,&regs,&regs);
    SetUp.DosVer1=regs.h.al;
    SetUp.DosVer2=regs.h.ah;
    // :: :: Drives detection

    // :: Write this default SetUp file
    WriteSetUp();
  }
  // Close the setup file
  delete FileIn;
  Error=0;
  // Force graphic mode to 640x480x16 if TurboC version
#ifdef __TURBOC__
  SetUp.ScreenX=640;
  SetUp.ScreenY=480;
  SetUp.ScreenColors=16;
#endif
  // Write the actual setup to Debugging file
  Debug("  SETUP...     System Font    = %s\n"
	    "               Screen Size    = (%d,%d) %d colors\n"
        "               DOS Version    = %d.%d\n",
	    SetUp.SystemFontName,
	    (int)(SetUp.ScreenX),(int)(SetUp.ScreenY),
        (int)(SetUp.ScreenColors),
        (int)(SetUp.DosVer1),(int)(SetUp.DosVer2));
  // Write the actual setup to the initialisation text screen
  printf("Current SetUp         : System Font    = %s\n"
         "                        Screen Size    = (%d,%d) %d colors\n"
         "                        DOS Version    = %d.%d\n",
	    SetUp.SystemFontName,
	    (int)(SetUp.ScreenX),(int)(SetUp.ScreenY),
        (int)(SetUp.ScreenColors),
        (int)(SetUp.DosVer1),(int)(SetUp.DosVer2));
}

void WriteSetUp(void)
{ TDisk *FileOut;
  char   FileName[200];
  // Build the full name for the SWORD2.CFG setup file
  sprintf(FileName,"%sSWORD.CFG",SwordPath);
  // Try to open this file
  FileOut=new TDisk(FileName,stCreate);
  // Write the setup into the file
  FileOut->Write(&SetUp,sizeof(TSetUp));
  // Close the setup file
  delete FileOut;
}

void DoneSetUp(void)
{ }
