/* Project SWORD
   V2.0

   SubSystem : ToolBox for 3D graphics
   File      : LibSrc/ToolBox/Graph3D/Point3D.CC
   Author    : Eric NICOLAS
   Overview  : Object TPoint3D
   UpDate    : Apr  3, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <math.h>

#include "Common/Common.H"
#include "Mecanism/Collec.H"
#include "ToolBox/Graph3D/Point3D.H"

// ----- Local vars

static TPoint3D Point3DTemp;

// ---- Object TPoint3D

// Constructors

TPoint3D::TPoint3D()
{ _X=_Y=_Z=0;
}

TPoint3D::TPoint3D(float X, float Y, float Z)
{ _X=X;
  _Y=Y;
  _Z=Z;
}

TPoint3D::TPoint3D(TPoint3D& P)
{ _X=P._X;
  _Y=P._Y;
  _Z=P._Z;
}

// operators between TPoint3Ds

TPoint3D TPoint3D::operator+(TPoint3D& P)
{ Point3DTemp._X=_X+P._X;
  Point3DTemp._Y=_Y+P._Y;
  Point3DTemp._Z=_Z+P._Z;
  return Point3DTemp;
}

TPoint3D TPoint3D::operator-(TPoint3D& P)
{ Point3DTemp._X=_X-P._X;
  Point3DTemp._Y=_Y-P._Y;
  Point3DTemp._Z=_Z-P._Z;
  return Point3DTemp;
}

TPoint3D TPoint3D::operator^(TPoint3D& P)
{ Point3DTemp._X=_Y*P._Z-_Z*P._Y;
  Point3DTemp._Y=_Z*P._X-_X*P._Z;
  Point3DTemp._Z=_X*P._Y-_Y*P._X;
  return Point3DTemp;
}

// operators betwwen TPoint3D and float

TPoint3D operator*(TPoint3D& P, float F)
{ Point3DTemp._X=F*P._X;
  Point3DTemp._Y=F*P._Y;
  Point3DTemp._Z=F*P._Z;
  return Point3DTemp;
}

TPoint3D operator/(TPoint3D& P, float F)
{ Point3DTemp._X=P._X/F;
  Point3DTemp._Y=P._Y/F;
  Point3DTemp._Z=P._Z/F;
  return Point3DTemp;
}

TPoint3D operator*(float F, TPoint3D& P)
{ Point3DTemp._X=F*P._X;
  Point3DTemp._Y=F*P._Y;
  Point3DTemp._Z=F*P._Z;
  return Point3DTemp;
}

// Order on 3D space

int comparison(TPoint3D& P1, TPoint3D& P2)
{ // Comparison on X
  if (P1._X<P2._X) return -1;
  if (P1._X>P2._X) return 1;
  // Here, P1._X==P2._X
  // -> Comparison on Y
  if (P1._Y<P2._Y) return -1;
  if (P1._Y>P2._Y) return 1;
  // Here, P1._Y==P2._Y
  // -> Comparison on Z
  if (P1._Z<P2._Z) return -1;
  if (P1._Z>P2._Z) return 1;
  // Here, P1._Z==P2._Z
  // -> P1==P2
  return 0;
}

// functions on TPoint3Ds

float norm(TPoint3D& P)
{ return sqrt(P*P);
}

TPoint3D TPoint3D::operator-()
{ Point3DTemp._X=-_X;
  Point3DTemp._Y=-_Y;
  Point3DTemp._Z=-_Z;
  return Point3DTemp;
}

// ----- TPoint3DCollection

TPoint3DCollection::TPoint3DCollection(long BeginSize, long SizeIncr) :
  TSortedCollection(BeginSize,SizeIncr)
{ }

int TPoint3DCollection::Comparison(Pvoid Item1, Pvoid Item2)
{ return comparison(*((TPoint3D*)Item1), *((TPoint3D*)Item2));
}

long TPoint3DCollection::PutPoint(TPoint3D **P)
{ long Pos;
  Pvoid V=*P;
  Pos=Put(&V);
  *P=(TPoint3D*)V;
  return Pos;
}

TPoint3D *TPoint3DCollection::GetPoint(long Position)
{ return (TPoint3D*)(Get(Position));
}

long TPoint3DCollection::GetPointPosition(TPoint3D *P)
{ return GetPosition((Pvoid)P);
}
