/* Project SWORD
   V2.0

   SubSystem : Image manipulation tools
   File      : Src/ToolBox/Image/ImgView.CC
   Author    : Eric NICOLAS
   Overview  : TImageScroller, TImageViewer Object : Voir des images
   UpDate    : Nov 12, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include "Drawings/Drawings.H"
#include "Gadgets/Gadgets.H"
#include "ToolBox/Image/Image.H"

// --- TImageScroller Object

short RegTImageScroller;
char *IdentTImageScroller = "TImageScroller";

TImageScroller::TImageScroller() : TScroller()
{ Init(NULL);
}

TImageScroller::TImageScroller(TRect& R, TImageFile *IF, TLift *H, TLift *V) :
   TScroller(R,IF->Width,IF->Height,H,V)
{ Init(IF);
}

void TImageScroller::Init(TImageFile *IF)
{ Register=RegTImageScroller;
  Ident=IdentTImageScroller;
  //
  ImageFile=IF;
}

void TImageScroller::Draw(TRect &)
{ int Limg=ImageFile->Width-DecX;
  int Himg=ImageFile->Height-DecY;
  if (Where.L()<Limg) Limg=Where.L();
  if (Where.H()<Himg) Himg=Where.H();
  ImageFile->Draw(DecX,DecY,Corner.X(),Corner.Y(),Limg,Himg);
  // Termine la zone de l'objet par du noir
  SetSysColor(GetColor(Black));
  if (Where.L()>Limg) Bar(Limg,0,Where.L()-1,Where.H()-1);
  if (Where.H()>Himg) Bar(0,Himg,Limg-1,Where.H()-1);
}

// --- TImageViewer Object

short RegTImageViewer;
char *IdentTImageViewer = "TImageViewer";

TImageViewer::TImageViewer() : TStdWindow()
{ Init(NULL);
}

TImageViewer::TImageViewer(int X, int Y, int L, int H, char *FileName) :
  TStdWindow(X,Y,L,H,"Image Viewer",TRUE)
{ Init(FileName);
}

TImageViewer::TImageViewer(TRect& R, char *FileName) :
  TStdWindow(R,"Image Viewer",TRUE)
{ Init(FileName);
}

void TImageViewer::Init(char *FileName)
{ Register=RegTImageViewer;
  Ident=IdentTImageViewer;
  //
  if (FileName==NULL) return;
  //
  ImageFile=new TImageFile(300,429);
  ImageFile->Load(FileName);
  // Insre les ascenseurs
  TLift *V=new TLift(Inside,FALSE);
  Insert(V);
  TLift *H=new TLift(Inside,TRUE);
  Insert(H);
  //
  Insert(new TWindowIFrame(Inside));
  // Insre l'afficheur d'image
  Insert(new TImageScroller(Inside,ImageFile,H,V));
  // Ajuste les couleurs dans la fenetre
  SetColorGroup(ColorGreen);
}

TImageViewer::~TImageViewer(void)
{ delete ImageFile;
}
